import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
let headers = {
'Content-Type': 'application/json;charset=UTF-8',
token: localStorage.getItem('storageToken'),
};

export const getCircleInfoReq = (id) => {
return fetch({
headers,
url: getBaseUrl(`circle/circle/${id}/info`),
method: 'get',
description: '获取圈子详情',
})
};
export const getCircleProvincesReq = (idType) => {
return fetch({
headers,
url: getBaseUrl(`circle/memberSelect/provinces/idType/${idType}`),
method: 'get',
description: '根据用户ID 获取选人时省市',
})
};
export const getMemberSelectOrgReq = (data) => {
return fetch({
headers,
url: getBaseUrl(`circle/memberSelect/org/search`),
method: 'post',
data: data,
description: '圈子设置查询机构列表',
})
};
export const getMemberSelectOrgOptionReq = (data) => {
  return fetch({
  headers,
  url: getBaseUrl(`circle/memberSelect/org/option`),
  method: 'post',
  data: data,
  description: '圈子设置勾选操作',
  })
  };




