import rangeJson from '@/utils/followup/followupUtils/range';

// 校验范围通用方法
export const checkRange = (rule, value, callback) => {
  let min,max;
  let val = Number(value);
  rangeJson.forEach((item)=>{
    if(item.field == rule.field){
      min = item.min;
      max = item.max;
    }
  })
  if((val >= min) && (val <= max)){
    callback()
  }else{
    callback(new Error(`输入范围${min}~${max}`))
  }
}

// 校验手机号
export const checkMobile = (rule, value, callback) => {
  var reg = /^1[3|4|5|7|8][0-9]{9}$/; //验证规则
  const flag = reg.test(value);
  if(flag){
    callback()
  }else{
    callback(new Error(`请输入正确的手机号码`))
  }
}

// 校验是否是整数
export const checkIsInteger = (rule, value, callback) => {
  const num = Number.isInteger(parseFloat(value));
  if(num){
    callback()
  }else{
    callback(new Error(`输入整数`))
  }
}

// 校验是否是一位小数
export const checkNumberIsToFixed = (rule, value, callback) => {
  const isNum = /^(([1-9][0-9]*)|(([0]\.\d{1,1}|[1-9][0-9]*\.\d{1,1})))$/;
  if(isNum.test(Number(value))){
    callback()
  }else{
    callback(new Error(`最多输入1位小数`))
  }
}

// 大于0的正整数
export const checkNormalInt = (rule, value, callback) => {
  const isInteger = Number.isInteger(parseFloat(value));
  const num = parseFloat(value);
  if(isInteger && num > 0){
    callback()
  }else{
    callback(new Error(`请输入大于0的正整数`))
  }
}
