export default ($this) => {
  return [



    {
      formType: 'div',
      name: '3.3 高血压',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'haveHypertension',
      model: 'haveHypertension',
      label: '随访期间新发现有高血压：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'diagnoseTime',
      model: 'diagnoseTime',
      placeholder: '请选择',
      label: '首次确诊时间：',
      linkageRule: [{ name: 'haveHypertension', value: ['2'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{ required: true, message: '首次确诊时间', trigger: 'change' }],
      spanNum: 6,
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'takeHypotensor',
      model: 'takeHypotensor',
      label: '是否服降压药：',
      linkageRule: [{ name: 'haveHypertension', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }],
      changeFun(e){
        if(e == 2) {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_008'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                typesOfMedication: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title4',
      prop: 'typesOfMedication',
      model: 'typesOfMedication',
      label: '用药种类：',
      linkageRule: [{name: 'takeHypotensor', value: ['2']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '利尿药', value: '1', disabled: false},
        {label: '钙拮抗剂', value: '2', disabled: false},
        {label: 'β受体阻滞剂', value: '3', disabled: false},
        {label: 'α受体阻滞剂', value: '4', disabled: false},
        {label: 'α，β受体阻滞剂', value: '5', disabled: false},
        {label: 'ACEI', value: '6', disabled: false},
        {label: 'ARB', value: '7', disabled: false},
        {label: '其他', value: '8', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'change'}]
    },

    {
      formType: 'radio',
      className: 'obj-form-title4',
      prop: 'medicationSituation',
      model: 'medicationSituation',
      label: '用药情况：',
      linkageRule: [{ name: 'takeHypotensor', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '规律', value: '1', disabled: false },
        { label: '不规律', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },

    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'bloodPressureControl',
      model: 'bloodPressureControl',
      label: '血压控制情况：',
      linkageRule: [{ name: 'haveHypertension', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '达标', value: '1', disabled: false },
        { label: '不达标', value: '2', disabled: false },
        { label: '不清楚', value: '3', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },


  ]
}
