import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'input',
      className: 'float-none',
      prop: 'name',
      model: 'name',
      label: '姓名：',
      disabled: false,
      placeholder: '请输入姓名',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      rules: [{required: true, message: '请输入姓名', trigger: ['submit','change']}],
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'no',
      model: 'no',
      label: '编号：',
      disabled: false,
      placeholder: '请输入编号',
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      rules: [{required: false, message: '请输入编号', trigger: ['submit','change']}],
    },
    {
      formType: 'date-picker',
      className: 'float-none',
      prop: 'followupDate',
      model: 'followupDate',
      placeholder: '请选择',
      label: '随访日期：',
      format: 'yyyy-MM-dd',
      valueFormat: 'yyyy-MM-dd',
      dateType: 'date',
      type: 'date',
      rules: [{required: true, message: '请选择随访日期', trigger: ['submit','change']}],
      spanNum: 12,
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'followupType',
      model: 'followupType',
      spanNum: 24,
      label: '随访方式：',
      options: [
        { label: '门诊', value: '门诊' },
        { label: '家庭', value: '家庭' },
        { label: '电话', value: '电话' },
      ],
      rules: [{ required: true, message: '请选择随访方式', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
  ]
}

