export default ($this) => {
  return [



    {
      formType: 'div',
      name: '3.3 高血压',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'haveHypertension',
      model: 'haveHypertension',
      label: '随访期间新发现有高血压：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择随访期间新发现有高血压', trigger: ['submit','change'] }]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'diagnoseTime',
      model: 'diagnoseTime',
      placeholder: '请选择',
      label: '首次确诊时间：',
      linkageRule: [{ name: 'haveHypertension', value: ['是'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{ required: true, message: '请选择首次确诊时间', trigger: ['submit','change'] }],
      spanNum: 6,
    },
    {
      formType: 'div',
      name: '如果有高血压（包括既往及本次随访期间新发现的高血压患者）',
      className: 'title-obj obj-form-title',
      spanNum: 24,
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'takeHypotensor',
      model: 'takeHypotensor',
      label: '是否服降压药：',
      // linkageRule: [{ name: 'haveHypertension', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否服降压药', trigger: ['submit','change'] }],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_008'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                typesOfMedication: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title4',
      prop: 'typesOfMedication',
      model: 'typesOfMedication',
      label: '用药种类：',
      linkageRule: [{name: 'takeHypotensor', value: ['是']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '利尿药', value: '利尿药', disabled: false},
        {label: '钙拮抗剂', value: '钙拮抗剂', disabled: false},
        {label: 'β受体阻滞剂', value: 'β受体阻滞剂', disabled: false},
        {label: 'α受体阻滞剂', value: 'α受体阻滞剂', disabled: false},
        {label: 'α，β受体阻滞剂', value: 'α，β受体阻滞剂', disabled: false},
        {label: 'ACEI', value: 'ACEI', disabled: false},
        {label: 'ARB', value: 'ARB', disabled: false},
        {label: '其他', value: '其他', disabled: false},
      ],
      rules: [{required: true, message: '请选择用药种类', trigger: ['submit']}]
    },

    {
      formType: 'radio',
      className: 'obj-form-title4',
      prop: 'medicationSituation',
      model: 'medicationSituation',
      label: '用药情况：',
      linkageRule: [{ name: 'takeHypotensor', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '规律', value: '规律', disabled: false },
        { label: '不规律', value: '不规律', disabled: false },
      ],
      rules: [{ required: true, message: '请选择用药情况', trigger: ['submit','change'] }]
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'bloodPressureControl',
      model: 'bloodPressureControl',
      label: '血压控制情况：',
      // linkageRule: [{ name: 'haveHypertension', value: ['是'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '达标', value: '达标', disabled: false },
        { label: '不达标', value: '不达标', disabled: false },
        { label: '不清楚', value: '不清楚', disabled: false },
      ],
      rules: [{ required: true, message: '请选择血压控制情况', trigger: ['submit','change'] }]
    },


  ]
}
