import fetch from '../fetch';
import { getFollowUpApi, getBasicDataApi, getFollowUpSC } from '@/utils/index'

import utils from './followupUtils';





const headers = {
  sysCode: 45
} /**/
/*工作台*/
export const getTodayAppointsList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayAppoints`),
    method: 'get',
    params: params,
    description: '获取今日预约列表',
  })
};
export const getTodayOverview = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayOverview`),
    method: 'get',
    params: params,
    description: '获取今日随访、预约、随访人数',
  })
};
export const getTodayPlans = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/overView/todayPlans`),
    method: 'get',
    params: params,
    description: '查询今日随访计划',
  })
};

/*计划管理*/
export const getPlanList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans`),
    method: 'get',
    params: params,
    description: '获取计划列表',
  })
};
export const getPlanDetail = (planId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/${planId}`),
    method: 'get',
    description: '获取计划详情',
  })
};
export const getNodeTimeList = (planId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/${planId}/time`),
    method: 'get',
    description: '获取随访时间节点列表',
  })
};
export const getNodeTimeContent = (planTimeId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans/time/${planTimeId}`),
    method: 'get',
    description: '获取节点详情',
  })
};
export const getResidentList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/`),
    method: 'get',
    params: params,
    description: '获取居民列表',
  })
};
export const getGroupList = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/group`),
    method: 'get',
    params: params,
    description: '获取分组列表',
  })
};
export const getResidentDetail = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/detail`),
    method: 'get',
    params: params,
    description: '获取居民详情',
  })
};
export const changePlan = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/planPatient/change`),
    method: 'put',
    params: params,
    description: '变更计划',
  })
};

/*预约管理*/
export const getReservationList = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appoint/appointed/list`),
    method: 'post',
    data: data,
    description: '获取预约列表',
  })
};
export const getCheckReservation = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appointmentPatient/check/`),
    method: 'get',
    params: params,
    description: '发送预约校验',
  })
};
export const getReservationPatients = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/appoint/appointed/count`),
    method: 'post',
    data: data,
    description: '查看预约人数',
  })
};
export const changeReservationStatus = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/appoint/status/`),
    method: 'post',
    data: data,
    description: '手动变更预约状态',
  })
};
export const sendReservation = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/appoint/`),
    method: 'post',
    data: data,
    description: '发送预约',
  })
};
/*录入管理*/
export const getEnteringList = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/list`),
    method: 'post',
    data: data,
    description: '录入列表查看',
  })
}
export const changeEnteringStatus = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/status/change`),
    method: 'post',
    data: data,
    description: '变更随访状态',
  },)
}
export const getEnteringInfo = (patientId, fuPlanPatientTimesId) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/entering/${patientId}/fuInfo/${fuPlanPatientTimesId}`),
    method: 'get',
    // params: params,
    description: '随访单条信息查看',
  },)
}

//新增随访计划
export const createFollowPlan = (data) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/followup/plans`),
    method: 'post',
    data: data,
    description: '新增随访计划',
  },)
}

//获取新建计划居民列表
export const getPlanPatientsList = (data) =>{
  data = data || {}
  return fetch({
    headers:{
      sysCode: 9
    },
    url: getFollowUpSC(`/healths/patients/infolist`),
    method: 'post',
    data: data,
    description: '获取新建计划居民列表',
  },)
}



/*常量*/
export const getBasicData = (params) => {
  return fetch({
    headers,
    url: getFollowUpSC(`/basic-data/constants/`),
    method: 'get',
    params: params,
    description: '获取常量',
  })
};
