import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token:  localStorage.getItem('storageToken'),
};
export const getGoodsList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/goods/query`),
    method: 'post',
    data: params,
    description: '商品列表查询',
  })
};
//
export const batchOnOff = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/goods/onoff/sale`),
    method: 'post',
    data: params,
    description: '批量上下架',
  })
};
export const updateGoods = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/goods/upsert`),
    method: 'post',
    data: params,
    description: '创建/更新商品',
  })
};
///dosage/all
export const dosageAll = (parm) => {
  return fetch({
    headers,
    url: getBaseUrl(`store/dosage/all`),
    method: 'get',
    // params: params,
    description: '剂型',
  })
};
export const getDeparts = (parm) => {
  return fetch({
    headers,
    url: getBaseUrl(`api-ws/departments/category`),
    method: 'get',
    // params: params,
    description: '科室',
  })
};

//`basic-data/constants?typeCode=P128`


export const updateStock = (parm) => {
  return fetch({
    headers,
    url: getBaseUrl(`trade/order/admin/query/${orderId}`),
    method: 'get',
    // params: params,
    description: '增加/减少库存',
  })
};
