import dataConverter from './dataConverter';
import fetch from '@/utils/fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'
import Vue from 'vue';

function getSaasHost(){
  var host;
  if(location.host.indexOf('dev-work')>-1 || location.host.indexOf('localhost')>-1){
    host = 'https://dev-saas.yunqueyi.com'
  }else if(location.host.indexOf('test1-work')>-1){
    host = 'https://test1.yunqueyi.com'
  }else if(location.host.indexOf('uat-work')>-1){
    host = 'https://uat.yunqueyi.com'
  }else{
    host = 'https://www.yunqueyi.com'
  }
  return host
}

function getWsHost(){
  var host;
  if(location.host.indexOf('dev-work')>-1 || location.host.indexOf('localhost')>-1){
    host = 'https://dev-ws.yunqueyi.com'
  }else if(location.host.indexOf('test1-work')>-1){
    host = 'https://test1-ws.yunqueyi.com'
  }else if(location.host.indexOf('uat-work')>-1){
    host = 'https://uat-ws.yunqueyi.com'
  }else{
    host = 'https://ws.yunqueyi.com'
  }
  return host
}

const alertMessage = (msg, confirmButtonText, cancelButtonText, callback) => {
  Vue.prototype.$confirm(msg, '提醒', {
    confirmButtonText: confirmButtonText,
    cancelButtonText: cancelButtonText,
    customClass: 'check-auth',
    showClose: false,
  }).then(() => {
    callback();
  }).catch(() => {
    // 关闭弹窗
  });
}

export default {
  DC: dataConverter,
  checkAuth: (callback) => {
    return new Promise((resolve, reject) => {
      resolve(fetch({
        headers: {
          token: localStorage.getItem('storageToken')
        },
        url: getBaseUrl(`/healths/doctor/hospitalAuth`),
        method: 'get',
        description: '检查用户的机构权限',
      }).then(res => {
        // 1、未加入 2、审核中 3、加入成功
        // res.data = 2
        if (res.code == '000000') {
          if (res.data == 1) {
            // 点击 去加入,进入加入机构流程
            alertMessage('您当前暂无机构，无法使用居民管理、随访管理和群发消息等功能，请在加入机构后重试。','去加入','暂不加入', ()=>{
              location.href = getSaasHost() + '/pica-base/pica_join.html'
            })
            return new Promise((resolve, reject) => {
            })
          } else if (res.data == 2) {
            alertMessage('您创建的机构正在审核中，暂无法使用居民管理、随访管理和群发消息等功能，请在审核通过后重试。','查看审核','取消', ()=>{
              location.href = getWsHost() + '/outside/status?tk=' + localStorage.getItem('storageToken')
            })
            return new Promise((resolve, reject) => {
            })
          } else if (res.data == 3) {
            return callback()
          }
        }
      }))

    })
  },
  checkAuthFunc: (callback)=>{
    return new Promise((resolve, reject) => {
      resolve(fetch({
        headers: {
          token: localStorage.getItem('storageToken')
        },
        url: getBaseUrl(`healths/doctor/hospitalAuth`),
        method: 'get',
        description: '检查用户的机构权限',
      }).then(res => {
        // res.data = 2
        if (res.code == '000000') {
          if (res.data == 1) {
            alertMessage('您当前暂无机构，无法使用居民管理、随访管理和群发消息等功能，请在加入机构后重试。','去加入','暂不加入', ()=>{
              location.href = getSaasHost() + '/pica-base/pica_join.html'
            })
          } else if (res.data == 2) {
            alertMessage('您创建的机构正在审核中，暂无法使用居民管理、随访管理和群发消息等功能，请在审核通过后重试。','查看审核','取消', ()=>{
              location.href = getWsHost() + '/outside/status?tk=' + localStorage.getItem('storageToken')
            })
          } else if (res.data == 3) {
          }
          return new Promise((resolve, reject) => {
            resolve(res.data)
          })
        }
      }))
    })

  }
};
