import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'

export const getSelectListReq = (type) => {
  return fetch({
    url: getBaseUrl(`cme/constants/list?code=${type}`),
    method: 'get',
    description: '获取学分等级 状态 学习形式',
  })
};

// export const getConstants = (params) => {
//     return fetch({
//       headers,
//       url: getBaseUrl(`basic-data/constants/`),
//       method: 'get',
//       params: params,
//       description: '获取常量',
//     })
// };


export const getCreditListReq = (params) => {
  return fetch({
    url: getBaseUrl(`cme/credit/list`),
    method: 'get',
    params: params,
    description: '获取积分管理列表',
  })
};



export const getRelatedCreditReq = (params) => {
  return fetch({
    url: getBaseUrl(`contents/certificate/select`),
    method: 'get',
    params: params,
    description: '获取关联学分证书列表',
  })
};

export const goUpReq = (data, id) => {
  return fetch({
    headers: {
      'Content-Type': 'application/json;charset=UTF-8',
      token: localStorage.getItem('storageToken'),
    },
    url: getBaseUrl(`cme/credit/deploy/${id}`),
    method: 'post',
    data: data,
    description: '上架',
  })
}

export const goDownReq = (data, id) => {
  return fetch({
    headers: {
      'Content-Type': 'application/json;charset=UTF-8',
      token: localStorage.getItem('storageToken'),
    },
    url: getBaseUrl(`cme/credit/revoke/${id}`),
    method: 'post',
    data: data,
    description: '下架',
  })
}

export const goAddNewReq = (data) => {
  return fetch({
    headers: {
      'Content-Type': 'application/json;charset=UTF-8',
      token: localStorage.getItem('storageToken'),
    },
    // url: 'http://10.177.15.4:13801/cme/credit/create',
    url: getBaseUrl(`cme/credit/create`),
    method: 'post',
    data: data,
    description: '新增学分记录',
  })
}

