import {getTodayAppointsList, getTodayOverview, getTodayPlans} from '@/utils/followup/followapis'

export default  {
  namespaced: true,
  state: {
    todayPlansList: [], //今日随访列表
    todayAppointsList: [], //今日预约列表
    todayOverview: [], //查询今日随访、预约、随访人数count
  },
  mutations: {
    GET_TODAY_PLAN_LIST(state, payload) {
     // state.todayPlansList = payload.data
      state.todayPlansList = [
        {
          patientName: 'wewe',
          status: 1,
          appointTime: '2019-03-05'
        }
      ]
    },
    GET_TODAY_APPOINTS_LIST(state, payload) {
      state.todayAppointsList = [
        {
          planName: 'wewe',
          appointTime: '2019-03-05'
        }
      ]
    },
    GET_TODAY_OVERVIEW(state, payload) {
      state.todayOverview = payload
    }
  },
  actions: {
    getTodayPlansList(context, payload) {
      getTodayPlans({
        ...payload
      }).then(({data}) => {
        context.commit('GET_TODAY_PLAN_LIST', data);
      });
    },
    getTodayAppointsList(context, payload) {
      getTodayAppointsList({
        ...payload
      }).then(({data}) => {
        context.commit('GET_TODAY_APPOINTS_LIST', data);
      });
    },
    getTodayOverview(context, payload) {
      getTodayOverview({
        ...payload
      }).then(({data}) => {
        context.commit('GET_TODAY_OVERVIEW', data);
      });
    }
  },
}
