import { checkNormalInt } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'div',
      name: '3.1 脑血管病',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'diseasedHappened',
      model: 'diseasedHappened',
      label: '履约期间有无新发脑血管病事件：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '无', disabled: false },
        { label: '有', value: '有', disabled: false },
      ],
      rules: [{ required: true, message: '请选择履约期间有无新发脑血管病事件', trigger: ['submit','change'] }]
    },
    {
      formType: 'input',
      className: 'obj-form-title2',
      linkageRule: [{name: 'diseasedHappened',value: ['有']}],
      prop: 'times',
      model: 'times',
      label: '发病次数：',
      disabled: false,
      placeholder: '请输入发病次数',
      spanNum: 6,
      type: 'number',
      labmsg: '次',
      slots: [{ name: '次', type: 'append' }],
      rules: [{ required: true, message: '请输入发病次数', trigger: ['submit','change'] }, { validator: checkNormalInt , trigger: ['submit','change'] }]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'firstTime',
      model: 'firstTime',
      placeholder: '请选择',
      label: '履约期间第一次发病时间：',
      linkageRule: [{ name: 'diseasedHappened', value: ['有'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{ required: true, message: '请选择履约期间第一次发病时间', trigger: ['submit','change'] }],
      spanNum: 12,
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'hospitalLevel',
      model: 'hospitalLevel',
      label: '就诊机构级别：',
      linkageRule: [{ name: 'diseasedHappened', value: ['有'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '省级医院', value: '省级医院', disabled: false },
        { label: '地市级医院', value: '地市级医院', disabled: false },
        { label: '县级医院', value: '县级医院', disabled: false },
        { label: '社区或乡镇卫生机构', value: '社区或乡镇卫生机构', disabled: false },
      ],
      rules: [{ required: true, message: '请选择就诊机构级别', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'mainDiagnosis',
      model: 'mainDiagnosis',
      label: '主要诊断：',
      linkageRule: [{ name: 'diseasedHappened', value: ['有'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '脑梗死', value: '脑梗死', disabled: false },
        { label: '脑出血', value: '脑出血', disabled: false },
        { label: '蛛网膜下腔出血', value: '蛛网膜下腔出血', disabled: false },
        { label: '短暂性脑缺血发作（TIA）', value: '短暂性脑缺血发作（TIA）', disabled: false },
      ],
      rules: [{ required: true, message: '请选择主要诊断', trigger: ['submit','change'] }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'beHospitalizedRecureTreat',
      model: 'beHospitalizedRecureTreat',
      label: '住院期间是否接受康复治疗：',
      linkageRule: [{ name: 'diseasedHappened', value: ['有'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择住院期间是否接受康复治疗', trigger: ['submit','change'] }]
    },
    {
      formType: 'div',
      name: '（注：两次发病时间应相隔28天以上，如有二次及以上发病者，请单独记录）',
      className: 'obj-form-title color-gray',
      spanNum: 24,
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'leaveHospitalRecureTreat',
      model: 'leaveHospitalRecureTreat',
      label: '出院后是否接受康复治疗：',
      linkageRule: [{ name: 'diseasedHappened', value: ['有'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择出院后是否接受康复治疗', trigger: ['submit','change'] }]
    },

  ]
}
