import fetch from '../fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'


const headers = {
  sysCode: 9
}

/*常量API*/
export const getConstants = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`basic-data/constants/`),
    method: 'get',
    params: params,
    description: '获取常量',
  })
};


/*居民管理*/
export const getPatientList = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/infolist`),
    method: 'post',
    data: data,
    description: '获取居民列表',
  })
};
export const getDiseasesList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/diseases/-1`),
    method: 'get',
    params: params,
    description: '获取所有疾病',
  })
};

export const getLabelList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/labels/`),
    method: 'get',
    params: params,
    description: '获取分组列表',
  })
}

// 获取七牛上传token
export const getQiniuToken = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`file/image/token`),
    method: 'get',
    params: params,
  })
};

// 意见反馈 getSaasApiDomain
export const submitFeedback = (data) => {
  return fetch({
    headers: {
      noSysCode: true,
      "Content-Type": 'application/json'
    },
    url: getSaasApiDomain(`web/companys/feedback`),
    method: 'post',
    data: data,
  })
};

/*资料不全居民*/
export const getNotCompleteList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncomplate/${params.pageNo}/${params.pageSize}`),
    method: 'get',
    description: '获取资料不全居民列表',
  })
};
export const sendCompleteMessage = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/remind`),
    method: 'post',
    data: data,
    description: '提醒居民完善信息',
  })
};
export const sendCompleteMessageList = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/list/remind`),
    method: 'post',
    data: data,
    description: '批量提醒居民完善信息',
  })
};
export const getNotCompleteCount = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncomplate/counts`),
    method: 'get',
    params: params,
    description: '获取未完善居民人数',
  })
};
export const getRedNum = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/uncompleted/last/counts`),
    method: 'get',
    params: params,
    description: '获取小红点数据',
  })
};
export const getPatientDetail = (patientId) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/${patientId}`),
    method: 'get',
    // params: params,
    description: '获取居民详情',
  })
};
export const deletePatient = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/batch`),
    method: 'delete',
    data: data,
    description: '删除居民',
  })
};
export const getRemindPatient = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/remind`),
    method: 'post',
    data: data,
    description: '提醒居民绑定微信',
  })
};
export const savePatientInfo = (data) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/patients/update`),
    method: 'post',
    data: data,
    description: '保存居民信息',
  })
};
export const getLabelsList = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`healths/labels/`),
    method: 'get',
    params: params,
    description: '获取分组列表',
  })
};
