import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [
    {
      formType: 'list',
      className: 'float-none',
      arrList: [
      ],
      prop: 'arrList',
      model: 'arrList',
      label: '',
      disabled: true,
      spanNum: 12,
      rules: [{required: false, message: '', trigger: ['submit','change']}],
      clickDeleteFunc: () => {
      }
    },
    {
      formType: 'button',
      className: 'float-none',
      prop: 'followUpOrgName',
      model: 'followUpOrgName',
      icon: 'el-icon-circle-plus',
      btnText: '点击添加',
      disabled: false,
      spanNum: 12,
      maxlength: 30,
      type: 'text',
      labmsg: '次',
      clickFunc: () => {
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceMedicationUse'){
            if($this.addComponents[index].formObject.arrList.length >= 3) {
              $this.$message.warning('最多只可添加3种药物!')
            }else {
              $this.dialogFormVisible = true;
            }
          }
        })
      }
    },
    {
      formType: 'div',
      name: '其他药物',
      className: 'sec-title',
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'medicinesName',
      model: 'medicinesName',
      label: '其他药物名称：',
      disabled: false,
      placeholder: '请输入其他药物',
      spanNum: 12,
      maxlength: 10,
      type: 'text',
      labmsg: '次',
      rules: [{required: false, message: '请输入其他药物', trigger: ['submit','change','blur']}],
      changeFun: (val)=>{
        let flag = val ? true : false;
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceMedicationUse'){
            $this.addComponents[index].dataSource.forEach((item,index2)=>{
              if($this.addComponents[index].dataSource[index2].rules){
                $this.addComponents[index].dataSource[index2].rules[0].required = flag;
              }
            })
          }
        })
      },
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'dosageDay',
      model: 'dosageDay',
      label: '其他药物用法：',
      disabled: false,
      placeholder: '请输入其他药物用法每日几次',
      spanNum: 12,
      maxlength: 10,
      type: 'text',
      slots: [{name: '次/日', type: 'append'}],
      rules: [{required: false, message: '请输入其他药物用法每日几次', trigger: ['submit','change','blur']},{ validator: checkRange , trigger: ['submit','change','blur'] }],
      changeFun: (val)=>{
        let flag = val ? true : false;
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceMedicationUse'){
            $this.addComponents[index].dataSource.forEach((item,index2)=>{
              if($this.addComponents[index].dataSource[index2].rules){
                $this.addComponents[index].dataSource[index2].rules[0].required = flag;
              }
            })
          }
        })
      },
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'dosageNum',
      model: 'dosageNum',
      label: '其他药物用量：',
      disabled: false,
      placeholder: '请输入其他药物每次用量',
      spanNum: 12,
      maxlength: 10,
      type: 'text',
      slots: [{name: '每次', type: 'append'}],
      rules: [{required: false, message: '请输入其他药物每次用量', trigger: ['submit','change','blur']}],
      changeFun: (val)=>{
        let flag = (val!=='' && val>=0) ? true : false;
        $this.addComponents.forEach((item,index)=>{
          if(item.name == 'hypeDataSourceMedicationUse'){
            $this.addComponents[index].dataSource.forEach((item,index2)=>{
              if($this.addComponents[index].dataSource[index2].rules){
                $this.addComponents[index].dataSource[index2].rules[0].required = flag;
              }
            })
          }
        })
      },
    },
  ]
}

