export default ($this) => {
  return [


    {
      formType: 'div',
      name: '3.4 血脂异常',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'haveDyslipidemia',
      model: 'haveDyslipidemia',
      label: '履约期间是否新发现有血脂异常：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择履约期间是否新发现有血脂异常', trigger: ['submit','change'] }],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_009'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                dyslipidemia: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'diagnoseTime',
      model: 'diagnoseTime',
      placeholder: '确诊时间',
      label: '首次确诊时间：',
      linkageRule: [{ name: 'haveDyslipidemia', value: ['是'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      spanNum: 6,
      rules: [{ required: true, message: '请选择首次确诊时间', trigger: ['submit','change'] }]
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'dyslipidemia',
      model: 'dyslipidemia',
      label: '血脂异常类型：',
      linkageRule: [{name: 'haveDyslipidemia', value: ['是']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '高胆固醇', value: '高胆固醇', disabled: false},
        {label: '高甘油三酯', value: '高甘油三酯', disabled: false},
        {label: '高LDL-C', value: '高LDL-C', disabled: false},
        {label: '低HDL-C', value: '低HDL-C', disabled: false},
        {label: '不详', value: '不详', disabled: false},
      ],
      rules: [{required: true, message: '请选择血脂异常类型', trigger: ['submit']}]
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'dyslipidemiaIf',
      model: 'dyslipidemiaIf',
      label: '是否有血脂异常（包括既往及本次履约期间新发现的血脂异常患者）：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否有血脂异常', trigger: ['submit','change'] }],

    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'takeAntilipemicAgents',
      model: 'takeAntilipemicAgents',
      label: '是否服用调脂药：',
      linkageRule: [{name: 'dyslipidemiaIf', value: ['是']}],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '否', disabled: false },
        { label: '是', value: '是', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否服用调脂药', trigger: ['submit','change'] }],
      changeFun(e){
        if(e == '是') {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_009'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                antilipemicAgentsType: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title3',
      prop: 'antilipemicAgentsType',
      model: 'antilipemicAgentsType',
      label: '选择的调脂药：',
      linkageRule: [{name: 'takeAntilipemicAgents', value: ['是']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '他汀类', value: '他汀类', disabled: false},
        {label: '贝特类', value: '贝特类', disabled: false},
        {label: '其他', value: '其他', disabled: false},
      ],
      rules: [{required: true, message: '请选择调脂药', trigger: ['submit']}]
    },

  ]
}
