export default ($this) => {
  return [
    {
      formType: 'div',
      name: '4.1 颈动脉',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'c26',
      model: 'c26',
      label: '支架术（CAS）',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '1', disabled: false},
        {label: '是', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'c29',
      model: 'c29',
      label: '支架术位置',
      linkageRule: [{name: 'c26', value: ['2']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '左侧', value: '1', disabled: false},
        {label: '右侧', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'c30',
      model: 'c30',
      placeholder: '请选择',
      label: '手术时间',
      linkageRule: [{name: 'c29', value: ['2']}],
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: 'blur'}],
      spanNum: 24,
    },


    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'c27',
      model: 'c27',
      label: '内膜剥脱术（CEA）',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '1', disabled: false},
        {label: '是', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'c31',
      model: 'c31',
      label: '内膜剥脱术位置',
      linkageRule: [{name: 'c27', value: ['2']}],
      disabled: false,
      changeFun: (val) => {
        // console.log(val)
      },
      spanNum: 24,
      options: [
        {label: '左侧', value: '1', disabled: false},
        {label: '右侧', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'c32',
      model: 'c32',
      placeholder: '请选择',
      label: '左侧手术时间',
      linkageRule: [{name: 'c31', value: ['1']}],
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: 'blur'}],
      spanNum: 24,
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title3',
      prop: 'c33',
      model: 'c33',
      placeholder: '请选择',
      label: '右侧手术时间',
      linkageRule: [{name: 'c31', value: ['2']}],
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: 'blur'}],
      spanNum: 24,
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'c28',
      model: 'c28',
      label: '颅内外血管搭桥术',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '1', disabled: false},
        {label: '是', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'c34',
      model: 'c34',
      placeholder: '请选择',
      label: '手术时间',
      linkageRule: [{name: 'c28', value: ['2']}],
      format: 'yyyy-MM-dd',
      type: 'date',
      rules: [{required: true, message: '手术时间', trigger: 'blur'}],
      spanNum: 24,
    },


    {
      formType: 'div',
      name: '4.2 冠状动脉',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'c35',
      model: 'c35',
      label: '介入术（PCI）',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '1', disabled: false},
        {label: '是', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'c36',
      model: 'c36',
      label: '搭桥术（CABG）',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '1', disabled: false},
        {label: '是', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },


    {
      formType: 'div',
      name: '4.3 出血性卒中外科治疗',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'c37',
      model: 'c37',
      label: '是否接受过出血性卒中外壳干预',
      disabled: false,
      spanNum: 24,
      options: [
        {label: '否', value: '1', disabled: false},
        {label: '是', value: '2', disabled: false},
      ],
      rules: [{required: true, message: '请选择是否', trigger: 'blur'}]
    },
  ]
}
