import { checkRange, checkIsInteger, checkNumberIsToFixed } from '@/utils/followup/followupUtils/checkField';

export default ($this) => {
  return [

    {
      formType: 'input',
      className: 'float-none',
      prop: 'smokingAmount',
      model: 'smokingAmount',
      disabled: false,
      label: '本次日吸烟量：',
      placeholder: '请输入本次日吸烟量',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '支/日', type: 'append'}],
      rules: [{ required: true, message: '请输入日吸烟量', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextSmokingAmount',
      model: 'nextSmokingAmount',
      disabled: false,
      label: '下次随访日吸烟量：',
      placeholder: '请输入下次随访日吸烟量',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '支/日', type: 'append'}],
      rules: [{ required: true, message: '请输入下次随访日吸烟量', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },


    {
      formType: 'input',
      className: 'float-none',
      prop: 'alcoholConsumption',
      model: 'alcoholConsumption',
      disabled: false,
      label: '本次日饮酒量：',
      placeholder: '请输入本次日饮酒量',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '两/日', type: 'append'}],
      rules: [{ required: true, message: '请输入本次日饮酒量', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextAlcoholConsumption',
      model: 'nextAlcoholConsumption',
      disabled: false,
      label: '下次随访日饮酒量：',
      placeholder: '请输入下次随访日饮酒量',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '两/日', type: 'append'}],
      rules: [{ required: true, message: '请输入下次随访日饮酒量', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },

    {
      formType: 'input',
      className: 'float-none',
      prop: 'workoutOfWeek',
      model: 'workoutOfWeek',
      disabled: false,
      label: '本次运动情况：',
      placeholder: '请输入本次运动情况',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '次/周', type: 'append'}],
      rules: [{ required: true, message: '请输入本次运动情况', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'workoutDuration',
      model: 'workoutDuration',
      disabled: false,
      placeholder: '请输入本次运动情况',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '分钟/次', type: 'append'}],
      rules: [{ required: true, message: '请输入本次运动情况', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },

    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextWorkoutOfWeek',
      model: 'nextWorkoutOfWeek',
      disabled: false,
      label: '下次随访运动情况：',
      placeholder: '请输入下次随访运动情况',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '次/周', type: 'append'}],
      rules: [{ required: true, message: '请输入下次随访运动情况', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },
    {
      formType: 'input',
      className: 'float-none',
      prop: 'nextWorkoutDuration',
      model: 'nextWorkoutDuration',
      disabled: false,
      placeholder: '请输入下次随访运动情况',
      spanNum: 6,
      maxlength: 30,
      type: 'text',
      labmsg: '',
      slots: [{name: '分钟/次', type: 'append'}],
      rules: [{ required: true, message: '请输入下次随访运动情况', trigger: ['submit','change'] },{ validator: checkRange , trigger: ['submit','change'] },]
    },


    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'saltIntake',
      model: 'saltIntake',
      spanNum: 24,
      label: '目前摄盐情况：',
      options: [
        { label: '轻', value: '轻' },
        { label: '中', value: '中' },
        { label: '重', value: '重' },
      ],
      rules: [{ required: true, message: '请选择目前摄盐情况', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'nextSaltIntake',
      model: 'nextSaltIntake',
      spanNum: 24,
      label: '下次随访摄盐情况：',
      options: [
        { label: '轻', value: '轻' },
        { label: '中', value: '中' },
        { label: '重', value: '重' },
      ],
      rules: [{ required: true, message: '请选择下次随访摄盐情况', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },

    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'psychologicalAdjustment',
      model: 'psychologicalAdjustment',
      spanNum: 24,
      label: '心理调整：',
      options: [
        { label: '良好', value: '良好' },
        { label: '一般', value: '一般' },
        { label: '差', value: '差' },
      ],
      rules: [{ required: true, message: '请选择心理调整', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'followMedicalPractive',
      model: 'followMedicalPractive',
      spanNum: 24,
      label: '遵医行为：',
      options: [
        { label: '良好', value: '良好' },
        { label: '一般', value: '一般' },
        { label: '差', value: '差' },
      ],
      rules: [{ required: true, message: '请选择心里调整', trigger: ['submit','change'] }],
      changeFun: (e)=>{
      }
    },
  ]
}

