import followApi from '../../utils/followup/followapis'

export default  {
  namespaced: true,
  state: {
    todayPlans: [], //今日随访列表
    todayAppointsList: [], //今日预约列表
    todayOverview: [], //查询今日随访、预约、随访人数count
  },
  mutations: {
    GET_TODAY_PLAN_LIST(state, payload) {
      state.groupList = payload
    },
    GET_TODAY_APPOINTS_LIST(state, payload) {
      state.groupList = payload
    },
    GET_TODAY_OVERVIEW(state, payload) {
      state.groupList = payload
    }
  },
  actions: {
    getTodayPlansList(context, payload) {
      followApi.getTodayPlansSC({
        ...payload
      }).then(({data}) => {
        context.commit('GET_TODAY_PLAN_LIST', data);
      });
    },
    getTodayAppointsList(context, payload) {
      followApi.getTodayAppointsListSC({
        ...payload
      }).then(({data}) => {
        context.commit('GET_TODAY_APPOINTS_LIST', data);
      });
    },
    getTodayOverview(context, payload) {
      followApi.getTodayOverviewSC({
        ...payload
      }).then(({data}) => {
        context.commit('GET_TODAY_OVERVIEW', data);
      });
    }
  },
}
