import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token:  localStorage.getItem('storageToken'),
};
/*查询运费配置信息*/
export const getExpressFee = () => {
  return fetch({
    headers,
    url: getBaseUrl(`/trade/coupon/express/fee/admin`),
    method: 'get',
    description: '查询运费配置信息',
  });
};

/*添加或修改运费配置信息*/
export const createOrModifyExpressFee = (params) => {
  return fetch({
    headers,
    url: `/trade/coupon/express/fee/admin/create`,
    method: 'post',
    data: params,
    description: '添加或修改运费配置信息',
  });
};


/*后台-查询运费配置信息*/
export const getFreightConfig = (value) => {
  return fetch({
    headers,
    url: getBaseUrl(`/store/admin/express/fee/store/${value.id}/config`),
    method: 'get',
    description: '后台-查询运费配置信息',
  });
};

/*后台-店铺运费配置信息-save*/
export const saveFreightConfig = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`/store/admin/express/fee/store/config/save`),
    method: 'post',
    data: params,
    description: '后台-店铺运费配置信息-save',
  });
};
