import dataConverter from './dataConverter';
import fetch from '@/utils/fetch';
import { getBaseUrl, getSaasDomain, getSaasApiDomain } from '@/utils/index'

export default {
  DC: dataConverter,
  checkAuth: (callback) => {
    return new Promise((resolve, reject) => {
      fetch({
        headers: {
          token: localStorage.getItem('storageToken')
        },
        url: getBaseUrl(`/healths/doctor/hospitalAuth`),
        method: 'get',
        description: '检查用户的机构权限',
      }).then(res => {
        // res.data = 2
        if (res.code == '000000') {
          // 1、未加入 2、审核中 3、加入成功
          if (res.data == 1) {
            alert('您当前暂无机构，无法使用居民管理、随访管理和群发消息等功能，请在加入机构后重试。')
            return new Promise((resolve, reject) => {
            })
          } else if (res.data == 2) {
            alert('您创建的机构正在审核中，暂无法使用居民管理、随访管理和群发消息等功能，请在审核通过后重试。')
            return new Promise((resolve, reject) => {
            })
          } else if (res.data == 3) {
            return callback
          }
        }
      })
    })
  }
};
