'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var axios = _interopDefault(require('axios'));

// 时间处理
Date.prototype.format = function (fmt) {
  // author: meizz
  let o = {
    'M+': this.getMonth() + 1,
    // 月份
    'd+': this.getDate(),
    // 日
    'h+': this.getHours(),
    // 小时
    'm+': this.getMinutes(),
    // 分
    's+': this.getSeconds(),
    // 秒
    'q+': Math.floor((this.getMonth() + 3) / 3),
    // 季度
    S: this.getMilliseconds()
  };
  if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length));

  for (let k in o) {
    if (new RegExp('(' + k + ')').test(fmt)) {
      fmt = fmt.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length));
    }
  }

  return fmt;
};

let axiosInstance = axios.create();
axiosInstance.interceptors.request.use(config => {
  // if (config.withCredentials) {
  //   config.headers.token = getItem('token');
  // }
  return config;
});
axiosInstance.interceptors.response.use(response => {
  let data = response.data == undefined ? response.request.responseText : response.data;
  return data;
});
function request(options) {
  const axiosConfig = {
    headers: {
      'X-Requested-With': 'XMLHttpRequest',
      'Content-Type': 'application/json;charset=UTF-8'
    },
    timeout: 10000,
    withCredentials: true,
    responseType: 'json',
    method: 'get'
  };
  options = Object.assign(axiosConfig, options);
  return new Promise((resolve, reject) => {
    axiosInstance(options).then(res => {
      resolve(res);
    }).catch(error => {
      reject(error);
    });
  });
}

/* eslint-disable-next-line */

/**
 * 签署最新版协议
 * @return {[type]}  协议类型 2：云鹊医用户协议 3：云鹊医隐私协议
 */

const signAgreementApi = async data => {
  return request({
    method: 'post',
    headers: {
      token: data.token
    },
    url: `${data.baseUrl}/smartcontract/protocol/sign?type=${data.type}`
  });
};

//
var script = {
  name: 'PicaH5Agreement',
  props: {
    baseUrl: {
      type: String,
      default: ''
    },
    agreementToken: {
      type: String,
      default: ''
    },
    agreementPageUrl: {
      type: String,
      default: ''
    },
    close: {
      type: Boolean,
      default: false
    }
  },

  data() {
    return {};
  },

  created() {},

  methods: {
    readAndAgree() {
      const _this = this;

      const data = {
        baseUrl: _this.baseUrl,
        token: _this.agreementToken,
        type: 3
      };
      signAgreementApi(data).then(res => {
        if (res.code == '000000') {
          _this.$emit('hasSignAgreement');
        }
      });
    },

    gotoAgreement() {
      //https://dev-scale.yunqueyi.com
      window.location.href = `${this.agreementPageUrl}/loginAgreement?token=${this.agreementToken}&pageUrl=${window.location.href}`;
    }

  }
};

function styleInject(css, ref) {
  if (ref === void 0) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') {
    return;
  }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}

var css = ".pica-h5-agreement-container[data-v-1c3d08a4] {\n  width: 8rem;\n  background: #fff;\n  border-radius: 0.08rem;\n  font-family: PingFangSC-Semibold;\n  box-shadow: 0 0 0.13333rem #ededed;\n  -webkit-user-select: none;\n          user-select: none;\n}\n.pica-h5-agreement-container .agreement-title[data-v-1c3d08a4] {\n  color: #333;\n  font-size: 0.48rem;\n  padding: 0.8rem 0 0.37333rem;\n  text-align: center;\n}\n.pica-h5-agreement-container .agreement-content[data-v-1c3d08a4] {\n  color: #676869;\n  font-size: 0.37333rem;\n  padding: 0 0.8rem 0.21333rem;\n  line-height: 0.56rem;\n}\n.pica-h5-agreement-container .agreement-content span[data-v-1c3d08a4] {\n  color: #449284;\n  text-decoration: underline;\n}\n.pica-h5-agreement-container .agreement-btn[data-v-1c3d08a4] {\n  color: #449284;\n  font-size: 0.45333rem;\n  text-align: center;\n  padding: 0.32rem 0;\n  border: 1PX solid #F0F1F2;\n}\n";
styleInject(css);

function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier
/* server only */
, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
  if (typeof shadowMode !== 'boolean') {
    createInjectorSSR = createInjector;
    createInjector = shadowMode;
    shadowMode = false;
  } // Vue.extend constructor export interop.


  const options = typeof script === 'function' ? script.options : script; // render functions

  if (template && template.render) {
    options.render = template.render;
    options.staticRenderFns = template.staticRenderFns;
    options._compiled = true; // functional template

    if (isFunctionalTemplate) {
      options.functional = true;
    }
  } // scopedId


  if (scopeId) {
    options._scopeId = scopeId;
  }

  let hook;

  if (moduleIdentifier) {
    // server build
    hook = function (context) {
      // 2.3 injection
      context = context || // cached call
      this.$vnode && this.$vnode.ssrContext || // stateful
      this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext; // functional
      // 2.2 with runInNewContext: true

      if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
        context = __VUE_SSR_CONTEXT__;
      } // inject component styles


      if (style) {
        style.call(this, createInjectorSSR(context));
      } // register component module identifier for async chunk inference


      if (context && context._registeredComponents) {
        context._registeredComponents.add(moduleIdentifier);
      }
    }; // used by ssr in case component is cached and beforeCreate
    // never gets called


    options._ssrRegister = hook;
  } else if (style) {
    hook = shadowMode ? function (context) {
      style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
    } : function (context) {
      style.call(this, createInjector(context));
    };
  }

  if (hook) {
    if (options.functional) {
      // register for functional component in vue file
      const originalRender = options.render;

      options.render = function renderWithStyleInjection(h, context) {
        hook.call(context);
        return originalRender(h, context);
      };
    } else {
      // inject component registration as beforeCreate hook
      const existing = options.beforeCreate;
      options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
    }
  }

  return script;
}

/* script */
const __vue_script__ = script;
/* template */

var __vue_render__ = function () {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c("div", {
    staticClass: "pica-h5-agreement-container"
  }, [_c("div", {
    staticClass: "agreement-title"
  }, [_vm._v("云鹊医隐私协议")]), _vm._v(" "), _c("div", {
    staticClass: "agreement-content"
  }, [_vm._v("\n        开启健康知识漫画领取后，您将免费获取来自云鹊医平台和医生的健康知识漫画分享内容，需要同意\n        "), _c("span", {
    on: {
      click: _vm.gotoAgreement
    }
  }, [_vm._v("《云鹊医平台隐私协议》")])]), _vm._v(" "), _c("div", {
    staticClass: "agreement-btn",
    on: {
      click: _vm.readAndAgree
    }
  }, [_vm._v("我已阅读并同意")])]);
};

var __vue_staticRenderFns__ = [];
__vue_render__._withStripped = true;
/* style */

const __vue_inject_styles__ = undefined;
/* scoped */

const __vue_scope_id__ = "data-v-1c3d08a4";
/* module identifier */

const __vue_module_identifier__ = undefined;
/* functional template */

const __vue_is_functional_template__ = false;
/* style inject */

/* style inject SSR */

/* style inject shadow dom */

var PicaH5Agreement = normalizeComponent({
  render: __vue_render__,
  staticRenderFns: __vue_staticRenderFns__
}, __vue_inject_styles__, __vue_script__, __vue_scope_id__, __vue_is_functional_template__, __vue_module_identifier__, false, undefined, undefined, undefined);

PicaH5Agreement.install = function (Vue) {
  Vue.component(PicaH5Agreement.name, PicaH5Agreement);
};

module.exports = PicaH5Agreement;
