import axios from 'axios';
import { Toast } from 'vant';
import { CryptoJS } from './aes'
import 'jsencrypt'

let pubKey = "";

// generate key
function getAesKey(len) {
  len = len || 16;
  var aesKey = "";
  var strList = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
  var strLen = strList.length;
  for(var i=0; i<len; i++){
  aesKey += strList.charAt( Math.floor( Math.random()*strLen ) );
  };
  return aesKey;
}

// 加密传参,发送请求
function sendEncryptRequest(content, cb, config){
  content = JSON.stringify(content);  // 后端要求转 string
  // debugger;
  if(pubKey){  // pubKey获取过就不用再获取了
      let params = formatContent(content, pubKey);
      cb && cb(params);
  }else{
      handleGetPubKey(content, cb, config);
  }
}

// 获取 RSA public key
function getPubKey(config) {
  return axios({ ...config, url: '/account/cipher/key' });
};

// get public key
function handleGetPubKey(content, cb, config){
  // debugger;
  getPubKey(config).then(res => {
      // console.log('>>>>>>>>>>>>>>>>>>>> publicKey: ', res);
      if(res.status && res.status === 200) {
        res = res.data;
      }
      // debugger;
      if(res.code == '000000'){
          pubKey = res.data;
          if(cb){
              let params = formatContent(content, pubKey);
              cb && cb(params);
          }
      }else{
          Toast({
            message: (res && res.message) || '接口出错',
            duration: 1500
          });
      }
  })
}

// format account params
function formatContent(content, pubKey) {  // obj为具体的json传参
  let aesKey = getAesKey(16);
  let params = {
      key: '',
      content: ''
  };
  // 开发阶段后端接口还没处理加密，先传 原始json数据 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 后端加密OK后 再用下面的注释代码
  // params.content = content;
  params.content = AesEncrypt(content, aesKey);
  params.key = RsaEncrypt(aesKey, pubKey);
  return params;
}

// AES encrypt
function AesEncrypt(content, aesKey) {
  let sKey = CryptoJS.enc.Utf8.parse(aesKey);
  let sContent = CryptoJS.enc.Utf8.parse(content);
  let encrypted = CryptoJS.AES.encrypt(sContent, sKey, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
  return encrypted.toString();
}

// RSA encrypt
function RsaEncrypt(aesKey, pubKey){  
  let _encrypt = new JSEncrypt();
  let boss_public_key = pubKey;
  _encrypt.setPublicKey(boss_public_key);
  let encrypted = _encrypt.encrypt(aesKey);
  return encrypted;
}


export {
  getAesKey,
  sendEncryptRequest,
  handleGetPubKey,
  formatContent,
  AesEncrypt,
  RsaEncrypt,
}