// 时间处理
Date.prototype.format = function(fmt) {
  // author: meizz
  let o = {
    'M+': this.getMonth() + 1, // 月份
    'd+': this.getDate(), // 日
    'h+': this.getHours(), // 小时
    'm+': this.getMinutes(), // 分
    's+': this.getSeconds(), // 秒
    'q+': Math.floor((this.getMonth() + 3) / 3), // 季度
    S: this.getMilliseconds()
  };
  if (/(y+)/.test(fmt))
    fmt = fmt.replace(
      RegExp.$1,
      (this.getFullYear() + '').substr(4 - RegExp.$1.length)
    );
  for (let k in o) {
    if (new RegExp('(' + k + ')').test(fmt)) {
      fmt = fmt.replace(
        RegExp.$1,
        RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length)
      );
    }
  }
  return fmt;
};
/**
 * 根据 URL key 获取 value
 * @param  {[type]} name [description]
 * @return {[type]}      [description]
 */
export const getSearchByName = name => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};
export const getItem = name => {
  if (!name) return;
  const v = localStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};
export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  localStorage.setItem(name, value);
};
export const removeItem = name => {
  if (!name) return;
  localStorage.removeItem(name);
};
export const isIos = () => {
  var u = navigator.userAgent;
  var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
  return isiOS;
};
export const isAndroid = () => {
  var u = navigator.userAgent;
  var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
  return isAndroid;
};
const REG_NO_BIAOQING = /\uD83C[\uDF00-\uDFFF]|\uD83D[\uDC00-\uDE4F]/gi;
/** @type {RegExp} 拒绝键盘表情 */
export const rnBiaoQing = v => {
  return v.replace(REG_NO_BIAOQING, '');
};
/**
 * 校验对象是否为空
 * */
export const isNotEmptyUtils = obj => {
  if ('' == obj || null == obj || undefined == obj || 'null' == obj) {
    return false;
  }
  return true;
};
/**
 * 校验对象是否为空
 * */
export const isEmptyUtils = obj => {
  return !isNotEmptyUtils(obj);
};
/**
 * 获取时间戳
 * @param {Date} [date]日期对象,为空时,返回当前时间戳
 * @return {String} timeStamp时间戳 格式:yyyyMMddhhmmssS
 */
export const timeStamp = date => {
  if (isEmptyUtils(date)) {
    return new Date().format('yyyyMMddhhmmssS');
  }
  return date.format('yyyyMMddhhmmssS');
};
//截位
export const subString = (obj, int) => {
  if (isEmptyUtils(obj) || isEmptyUtils(int)) {
    return '';
  }
  if (obj.length <= int) {
    return obj;
  } else {
    obj = obj.substring(0, int);
  }
  return obj;
};
/**
 * 获取全局唯一标识符（GUID，Globally Unique Identifier）
 * @return {String} guid
 */
export const guid = () => {
  /**
   * @return {String}
   */
  function S4() {
    return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
  }
  return (
    S4() +
    S4() +
    '-' +
    S4() +
    '-' +
    S4() +
    '-' +
    S4() +
    '-' +
    S4() +
    S4() +
    S4()
  );
};
/**
 * 设置图片
 * @param  {[type]} action [description]
 * @param  {[type]} url    [description]
 * @return {[type]}        [description]
 */
export function setImage(action, url) {
  // action : add / del
  console.log('hhahahahaha', this);
  const { imagesObject } = this;
  if ('add' == action) {
    imagesObject[url] = url;
  } else {
    delete imagesObject[url];
  }
  this.imagesObject = imagesObject;
  this.images = Object.keys(imagesObject);
}
export const isApp = () => {
  // if (['test', 'uat', 'prod'].indexOf(process.env.VUE_APP_ENV)) return true;
  if (window.__isAndroid || window.__isIOS) return true;
  return false;
};
export const setCookie = (name, value, time) => {
  var expires = 30 * 24 * 60 * 60 * 1000; //一天
  var date = new Date(+new Date() + expires);
  if (time) {
    document.cookie =
      name +
      '=' +
      escape(value) +
      '; path=/' +
      ';expires=' +
      date.toUTCString();
  } else {
    document.cookie = name + '=' + escape(value) + '; path=/';
  }
};
export const removeCookie = key => {
  var expires = -1 * 24 * 60 * 60 * 1000; //一天
  var date = new Date(+new Date() + expires);
  document.cookie =
    key + '=' + escape('') + '; path=/' + ';expires=' + date.toUTCString(); //这里只需要把Cookie保质期退回一天便可以删除
};
export const getCookie = key => {
  var cookieArr = document.cookie.split('; ');
  for (var i = 0; i < cookieArr.length; i++) {
    var arr = cookieArr[i].split('=');
    if (arr[0] === key) {
      return arr[1];
    }
  }
  return '';
};

/**
 * iPhone X、iPhone XS
 */
export const isIPhoneX = () => {
  return (
    /iphone/gi.test(window.navigator.userAgent) &&
    window.devicePixelRatio &&
    window.devicePixelRatio === 3 &&
    window.screen.width === 375 &&
    window.screen.height === 812
  );
};

/**
 * iPhone XS Max
 */
export const isIPhoneXSMax = () => {
  return (
    /iphone/gi.test(window.navigator.userAgent) &&
    window.devicePixelRatio &&
    window.devicePixelRatio === 3 &&
    window.screen.width === 414 &&
    window.screen.height === 896
  );
};

/**
 * iPhone XR
 */
export const isIPhoneXR = () => {
  return (
    /iphone/gi.test(window.navigator.userAgent) &&
    window.devicePixelRatio &&
    window.devicePixelRatio === 2 &&
    window.screen.width === 414 &&
    window.screen.height === 896
  );
};

/**
 * 时间戳转化为年 月 日 时 分 秒
 */
export const formatTime = timeStamp => {
  let time = new Date(timeStamp),
    y = time.getFullYear(),
    m = time.getMonth() + 1,
    d = time.getDate(),
    h = time.getHours(),
    mm = time.getMinutes();
  // s = time.getSeconds();

  return y + '-' + add0(m) + '-' + add0(d) + ' ' + add0(h) + ':' + add0(mm);
};

//数据转化
function add0(m) {
  return m < 10 ? '0' + m : m;
}
