###### 使用说明
> h5登录成功后判断是否签署协议

###### 1. 使用

```javascript
import PicaH5Agreement from 'pica-h5-agreement';
// if for global use
Vue.use(PicaH5Agreement);
```
```html

// template need popup
<van-popup v-model="isShowAgreement" :close-on-click-overlay="false">
	<pica-h5-agreement
		:close="true"
		:base-url="baseUrl"
		:agreement-token="agreementToken"
		:agreement-page-url="agreementPageUrl"
		@hasSignAgreement="hasSignAgreement"
	/>
</van-popup>
```

```javascript
// 代码
export default {
	methods: {
		hasSignAgreement() {
			this.isShowAgreement = false;
		}
	}
}

```

###### 2. options

| 参数      | 说明                   | 类型     | 默认值   |
| --------- | ---------------------- | -------- | -------- |
| baseUrl   | 接口域名               | string   | 空       |
| close     | 是否显示 close 符号    | boolean  | false    |
| agreementToken     | 需要传的token    | string  | ''    |
| agreementPageUrl     | 需要传的协议页面的地址域名  | string  | ''    |
| signAgreement     | 同意协议后的回调    | function  | () => {}    |

> baseUrl: 
> dev : http://dev-sc.yunqueyi.com
> test1: http://test1-sc.yunqueyi.com
> uat: http://uat-sc.yunqueyi.com

> agreementPageUrl: 
> dev : https://dev-scale.yunqueyi.com
> test1: https://test1-scale.yunqueyi.com
> uat: https://uat-scale.yunqueyi.com
