###### 使用说明
> 由于H5 登录成功后调用后台接口判断是否签署协议，如果签署了就不再弹出协议签署框，如果没有则弹出协议弹窗，同意协议则跳转相应页面，不同意则返回上个页面

###### 1. 使用

```javascript
import PicaH5Agreement from 'pica-h5-agreement';
// if for global use
Vue.use(PicaH5Agreement);
```
```html
// template
<pica-h5-login 
	:close="true"
	:base-url="baseUrl"
	@login-call="loginCall"
	@close-call="closeCall"
/>

// template need popup
<van-popup v-model="show">
	<pica-h5-login
		:close="true"
		:base-url="baseUrl"
		@login-call="loginCall"
		@close-call="closeCall"
	/>
</van-popup>
```
```javascript
// 代码
export default {
	data() {
		return {
			show: false
		}
	},
	methods: {
		loginCall(token) {
			// 登录成功回调返回值就是token
			this.closeCall();
		},
		closeCall() {
			this.show = false;
		}
	}
}
```

```javascript
vue.config.js 新增配置

transpileDependencies: ['pica-h5-login']
```

###### 2. options

| 参数      | 说明                   | 类型     | 默认值   |
| --------- | ---------------------- | -------- | -------- |
| baseUrl   | 登录域名               | string   | 空       |
| close     | 是否显示 close 符号    | boolean  | false    |
| loginCall | 登录成功回调函数       | function | (token) => {} |
| closeCall | 关闭登录窗口的回调函数 | function | () => {} |

> baseUrl: 
> dev : http://dev-sc.yunqueyi.com
> test1: http://test1-sc.yunqueyi.com
> uat: http://uat-sc.yunqueyi.com

