import axios from 'axios';
import { getItem } from '../utils/index.js';

let axiosInstance = axios.create();
axiosInstance.interceptors.request.use(
  config => {
    // if (config.withCredentials) {
    //   config.headers.token = getItem('token');
    // }
    return config;
  }
);

axiosInstance.interceptors.response.use(
  response => {
    let data =
      response.data == undefined
        ? response.request.responseText
        : response.data;
    return data;
  }
);

export default function request(options) {
  const axiosConfig = {
    headers: {
      'X-Requested-With': 'XMLHttpRequest',
      'Content-Type': 'application/json;charset=UTF-8'
    },
    timeout: 10000,
    withCredentials: true,
    responseType: 'json',
    method: 'get'
  };
  options = Object.assign(axiosConfig, options);

  return new Promise((resolve, reject) => {
    axiosInstance(options)
      .then(res => {
        resolve(res);
      })
      .catch(error => {
        reject(error);
      });
  });
}
