const vueFilter = {
    // 直播
    liveDateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm:ss");
    },
    liveFilter: (value) => {
        if(value.liveStatus == 1){
            return '未开始'
        } else if(value.liveStatus == 5) {
            return '直播中'
        }else if(value.liveStatus == 10 && value.lookBackStatus == 2){
            return '已结束(不可回看)'
        }else if(value.liveStatus == 10 && value.lookBackStatus == 1) {
            return '已结束(可回看)'
        }
    },
    liveStatusFilter: (value) => {
        if(value == 1) return "隐藏"
        else return "发布"    
    },
    liveTeacherType: (value) => {
        let doctorName = []
        if(value.length > 3) {
            for(let i = 0; i < 3; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、") + '...'
        }else{
            for(let i = 0; i < value.length; i++) {
                doctorName.push(value[i].doctorName)
            }
            return doctorName.join("、")
        }  
    },
    // 积木
    controlType: (value) => {
        if(value == 1) {
            return '分页1'
        }else if(value == 2) {
            return '分页2'
        }else if(value == 3) {
            return '图片1'
        }else if(value == 4) {
            return '图片2'
        }else if(value == 6) {
            return '视频'
        }else if(value == 7) {
            return '讨论'
        }else if(value == 8) {
            return '资格校验'
        }else if(value == 11) {
            return '活动模板'
        }
    },
    tabControlType: (value) => {
        if(value == 3) {
            return '图片1'
        }else if(value == 4) {
            return '图片2'
        }else if(value == 6) {
            return '视频'
        }else if(value == 7) {
            return '讨论'
        }else if(value == 8) {
            return '资格校验'
        }else if(value == 11) {
            return '活动模板'
        }
    },
    refreshType: (value) => {
        if(value == 1) return "支持"
        else return "不支持"    
    },
    moudleType: (value) => {
        if(value == 1) return "未激活"
        else return "激活" 
    },
    dateFilter: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm");
    },
    templateFilter: (value) => {
        if(value == 1) return '任务';
    },
    continueTimeFilter: (value) => {
        if(value.endTime) {
            return value.beginTimeStr + '-' + value.endTimeStr;
        }else {
            return value.beginTimeStr;
        }
    },
    taskActivityStatus: (value) => {
        if(value.isDisabled == 2) {
            return '禁用'
        }else {
            if(value.status == 1) {
                return '进行中';
            }else {
                return '未进行';
            }
        }
    },
    // 栏位
    appColumnStatusFilter: (value) => {
        if(value == 1) return "未提交"
        else if(value == 4) return "已提交"  
    },
    appContentStatusFilter: (value) => {
        if(value == 1) return "未提交"
        else if(value == 2) return "已提交"  
    },
    statusFilter: (value) => {
        if(value == 1) return "已创建"
        else if(value == 5) return "已发布"
        else return "已下架"    
    },
    linkTypeFilter: (value) => { // 跳转类型
        if(value == 1) return '链接'
        else if(value == 4) return '模块'
        else return '无跳转'
    },
    teacherStatusFilter: (value) => {
        if(value == 1) return "已下架"
        else return "已发布"    
    },
    moduleTypeFilter: (value,data) => {  // 模块类型
        for(let key in data) {
            if(value == key) {
                return data[key]
            }
        }
    },
    contentCreatedType: (value,data) => {
        let userName = ''
        for(let i=0; i < data.length;i++) {
            if(value == data[i].id) {
                userName = data[i].name
                break
            }else {
                userName = ''
            }
        }
        return userName
    },
    contentModifiedType: (value,data) => {
        let userName = ''
        for(let i=0; i < data.length;i++) {
            if(value == data[i].id) {
                userName = data[i].name
                break
            }else {
                userName = ''
            }
        }
        return userName
    },
    columnPageType: (value,data) => { // 页面类型
        for(let key in data) {
            if(value == key) {
                return data[key]
            }
        }
    },
    columnPositionType: (value,data) => {  // 位置
        for(let key in data) {
            if(value == key) {
                return data[key]
            }
        }
    },
    columnCreatedType: (value,data) => { // 创建人
        // let _index = data.findIndex((_value,index,arr) => {
        //     return value == _value.id
        // })
        // return data[_index].name
        let userName = ''
        for(let i=0; i < data.length;i++) {
            if(value == data[i].id) {
                userName = data[i].name
                break
            }else {
                userName = ''
            }
        }
        return userName
    },
    columnSubmitedType: (value,data) => { // 提交人
        // let _index = data.findIndex((_value,index,arr) => {
        //     return value == _value.id
        // })
        // return data[_index].name

        let userName = ''
        for(let i=0; i < data.length;i++) {
            if(value == data[i].id) {
                userName = data[i].name
                break
            }else {
                userName = ''
            }
        }
        return userName
    },
    liveIdFilter: (value,data) => {  // 直播名称
        let _index = data.findIndex((_value,index,arr) => {
            return value == _value.id
        })
        return data[_index].name
    },
    managerFilter: (value) => {
        if(value == 1) {
            return '普通用户'
        }else if(value == 2) {
            return '讲师本人'
        }else if(value == 3) {
            return '管理员'
        }else {
            return '白名单'
        }
    },
    sortStatuFilter: (value) => {
        if(value == true) return '已发布'
        else return '未发布'
    },
    courseTypeFilter: (value) => {
        if(value == 1) {
            return '入门'
        } else if(value == 2) {
            return '中级'
        } else if(value == 3) {
            return '高级'
        }
    },
    nameManageStatus: (value) => {
        if(value == 1) {
            return '未发布';
        }else {
            return '已发布'
        }
    },
    dateFormat: (value) => {
        if (!value) return '';
        return new Date(value).format("yyyy-MM-dd hh:mm:ss");
    },
    getVersion: (value) => {
        let version = value.appVersion;
        if(value.range == 1) {
            version += '及以上'
        } else if(value.range == 2) {
            version += '及以下'
        }
        return version
    },
}
export default vueFilter