const { NUXT_ENV_APP } = process.env;

export const BASE_URL = {
  //dev: 'https://dev-sc.yunqueyi.com',
  dev:'https://dev-sc.yunqueyi.com',
  test: 'https://test1-sc.yunqueyi.com',
	uat: 'https://uat-sc.yunqueyi.com',
  prod: 'https://sc.yunqueyi.com'  
};

export const API_CONFIG = {
  baseURL: BASE_URL[NUXT_ENV_APP],
  headers: {
    'X-Requested-With': 'XMLHttpRequest',
    'Content-Type': 'application/json;charset=UTF-8'
  },
  timeout: 10000,
  withCredentials: false,
  responseType: 'json',
  method: 'get'
}

export const REPONSE_CODE = {
  400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
  401: '用户没有权限（登录过期、token错误）',
  403: '用户得到授权，但是访问是被禁止的。',
  404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
  406: '请求的格式不可得。',
  410: '请求的资源被永久删除，且不会再得到的。',
  422: '当创建一个对象时，发生一个验证错误。',
  500: '服务器发生错误，请检查服务器。',
  502: '网关错误。',
  503: '服务不可用，服务器暂时过载或维护。',
  504: '网关超时。'
};

export const ENV_CONFIG = {
    development: {
        baseUrl: 'http://10.177.10.217:10201/',
        apiUrl: 'https://dev-api.yunqueyi.com/',
        shareUrl: 'https://dev-phome.yunqueyi.com/',
        topicUrl: 'http://10.177.11.245:8081',
		wxLoginUrl : 'https://sc.yunqueyi.com/wechats/users',
	

 
    },
    dev: {
        baseUrl: 'https://dev-sc.yunqueyi.com/',
        apiUrl: 'https://dev-api.yunqueyi.com/',
        shareUrl:'https://dev-phome.yunqueyi.com/',
        topicUrl:'https://dev-discuss.yunqueyi.com',
            
        wxLoginUrl: 'https://sc.yunqueyi.com/wechats/users',
        domain:'https://dev-sc.yunqueyi.com/account',
        APPID:'wx2c577552a2d28550',
      
       
    },
    test: {
        baseUrl: 'https://test1-sc.yunqueyi.com/',
        apiUrl: 'https://test1-api.yunqueyi.com/',
        shareUrl: 'https://test1-phome.yunqueyi.com/',
        topicUrl: 'https://test1-discuss.yunqueyi.com',
		wxLoginUrl : 'https://test1-sc.yunqueyi.com/wechats/users',
		domain : 'https://test1-sc.yunqueyi.com/account',
		APPID:'wxebc0cc65cca7694b' ,
        

    },
    uat: {
        baseUrl: 'https://uat-sc.yunqueyi.com/',
        apiUrl: 'https://uat-api.yunqueyi.com/',
        shareUrl: 'https://uat-phome.yunqueyi.com/',
        topicUrl: 'https://uat-discuss.yunqueyi.com',
		wxLoginUrl : 'https://uat-sc.yunqueyi.com/wechats/users',
		domain : 'https://uat-sc.yunqueyi.com/account',
		APPID:'wx342ef0e5afee54a7',
       
    },
    prod: {
        baseUrl: 'https://sc.yunqueyi.com/',
        apiUrl: 'https://api.yunqueyi.com/',
        shareUrl: 'https://phome.yunqueyi.com/',
        topicUrl: 'https://discuss.yunqueyi.com',
		wxLoginUrl : 'https://sc.yunqueyi.com/wechats/users',
		domain : 'https://sc.yunqueyi.com/account',
		APPID:'wx2c577552a2d28550',
       
    }
};


