// 年终活动第二期 主页面请求

import request from './api';

// 获取用户信息
// /ranking/user_info

export const getUserScoreInfo = () => {
	return request({
    url: `campaign/ranking/user_info`,
    method: 'post',
    withCredentials: true,
    // headers: {
    //   token: '8F685DEFFEAC45C393AA55A4DD9E9048'
    // }
  })
}

// 获取已邀请的医生列表
export const getInviteList = () => {
	return request({
    url: `campaign/inviteDetail/oneList?pageNo=1&pageSize=10`,
    method: 'get',
    withCredentials: true,
    // headers: {
    //   token: token
    // }
  })
}

// 获取打卡状态
export const getClockStatus = (params) => {
	return request({
    url: `campaign/clock/${params.activityId}/status/${params.id}`,
    method: 'get',
    withCredentials: true,
  })
}

// 去打卡状态
export const goToUpdateClock = (params) => {
	return request({
    url: `campaign/clock/clock`,
    method: 'post',
    data: params,
    withCredentials: true,
  })
}

// 获取activityId
export const getActivityId = () => {
	return request({
    url: `contents/commonComstant/selectByTypeCode?code=C015`,
    method: 'get',
    // withCredentials: true,
  })
}

// 获取任务列表
export const getTimsActivityInfo = (id) => {
	return request({
    url: `campaign/tims/timsActivityInfo?activityId=${id}`,
    method: 'get',
    withCredentials: true,
  })
}

export const selectAppModuleParam = async ({id, token }) => {
  return request({
    url: `/contents/contentAppModule/selectAppModuleParam?id=${id}&token=${token}&setEntry=true`,
    withCredentials: true
  });
}

export const checkToken = async({token}) => {
  return request({
    url: `campaign/admin/task/checkToken?token=${token}`,
    withCredentials: true
  })
}

export const getRole = async ({ token }) => {
  return request({ 
    url: `/contents/template/getRole?token=${token}`,
    headers: {
      token
    }
    // withCredentials: true
  });
}

export const sayHello = async ({ token }) => {
  return request({
    method: 'POST',
    // withCredentials: true,
     headers: {
      token
    },
    data: { token },
    url: `/diplomat/oauth/sayhello?app_id=pica-crrs`
  });
}

// 获取加密过后的id
export const getEncryptId = () => {
	return request({
    url: `campaign/inviteDetail/vinci`,
    method: 'get',
    withCredentials: true,
  })
}
