import Vue from 'vue'
import {
	BASE_URL
} from '@/utils/enumerate';
import PicaCallApp from 'pica-call-app';
import PicaWxShare from 'pica-wx-share';
Vue.prototype.$picaWxShare = PicaWxShare;

import PicaH5Login from 'pica-h5-login';
import {
	CountDown,
	Field,
	Cell,
	CellGroup,
	Button,
	Dialog,
	Toast,
	Checkbox,
	Popup,
	CheckboxGroup,
	RadioGroup,
	Radio,
	Progress,
	ImagePreview,
	Uploader,
	Overlay,
	Loading
} from 'vant';
import WebBuriedPoint, {
	sendBuriedData
} from 'web-buried-point';

Vue.use(PicaCallApp);
Vue.use(CountDown).use(Field).use(Cell).use(CellGroup).use(Button).use(Popup).use(Checkbox).use(CheckboxGroup).use(RadioGroup).use(Radio).use(Progress).use(ImagePreview).use(Uploader).use(Overlay).use(Loading);
Vue.use(PicaH5Login);
Vue.use(Toast);
Vue.use(Dialog);


const {
	NUXT_ENV_APP
} = process.env;

Vue.use(WebBuriedPoint, {
	class_name: `year_end_ssr`,
	url: `${BASE_URL[NUXT_ENV_APP]}/file/log/trace1`
});

Vue.prototype.$sendBuriedData = sendBuriedData;