const { NUXT_ENV_APP } = process.env;

export const setCookie = (cname,cvalue, exdays = 7, domain = '.yunqueyi.com') => { //yunqueyi.com
  let d = new Date(), expires = '';
  
  if (NUXT_ENV_APP === 'dev') {
    domain = window.location.hostname;  
  }
  d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
  expires = `expires=${d.toUTCString()}`;
  
  document.cookie = `${cname}=${cvalue};path=/;${expires};domain=${domain}`;
}

export const getCookie = (cname) => {
  const reg = new RegExp('(^| )' + cname + '=([^;]*)(;|$)');
  const arr = document.cookie.match(reg);

  return arr ? unescape(arr[2]) : null;
}

export const delCookie = (cname) => {
  var exp = new Date();
        exp.setTime(exp.getTime() - 1);
        var cval = getCookie(cname);
        
        if(cval!=null){
            document.cookie = 'token=; path=/; expires=' + new Date(0).toUTCString();
            document.cookie = 'token=; path=/; domain=.yunqueyi.com; expires=' + new Date(0).toUTCString();
            //document.cookie= name + "="+cval+";path=/;expires="+exp.toGMTString() + ";domain=" + domain;
        } 
}
