// 明细页排名也接口

import request from './api';

// 获取领取记录列表
export const getOneInviteDetails = (params) => {
	return request({
    url: `campaign/inviteDetail/oneList`,
    params: params,
    withCredentials: true
  })
}// 获取领取记录列表
export const getTwoInviteDetails = (params) => {
  return request({
    url: `campaign/inviteDetail/twoList`,
    params: params,
    withCredentials: true
  })
}
// 获取个人明细列表
export const getPersonDetails = (params) => {
  return request({
    url: `/campaign/tims/personalDetails`,
    params: params,
    withCredentials: true
  })
}
// 获取今日个人排行榜
export const getTodayUserRanking = (data) => {
  return request({
    url: `/campaign/ranking/today_user_ranking`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}

// 获取累计排行榜
export const getAllUserRanking = (data) => {
  return request({
    url: `/campaign/ranking/user_ranking`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}
// 获取个人贡献榜
export const getContributionRanking = (data) => {
  return request({
    url: `/campaign/ranking/contribution_ranking`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}
// 获取机构排行榜
export const getHospitalRanking = (data) => {
  return request({
    url: `/campaign/ranking/hospital_ranking`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}
// 获取昨日获奖名单
export const getYesterdayRanking = (data) => {
  return request({
    url: `/campaign/ranking/yesterday_user_ranking`,
    method: 'post',
    data: data,
    withCredentials: true
  })
}