import request from './api';

// 获取机构和个人参与人数
export const getCnt = () => {
	return request({
		url: `campaign/preBook/cnt`,
    method: 'get',
	})
}

// 查看当前token的机构状态
export const checkHospitalStatus = (token) => {
	return request({
    url: `api-ws/doctors/hospital/status`,
    method: 'get',
    headers: {
      token: token
    }
  })
}

// 设置开赛提醒接口 post
export const remind = (params) => {
  return request({
    url: `campaign/preBook/book`,
    method: 'post',
    data: {"activityId":1},	// 为了日后的扩展，暂时固定传 1
    headers: {
      token: params.token
    }
  })
}

// 预约状态 get
export const getRemindStatus = async (token) => {
	return request({
    url: `campaign/preBook/status`,
    method: 'get',
    headers: {
      token: token
    }
  })
}

// 校验token是否有效
export const checkToken = async (token) => {
  return request({
    url: `campaign/admin/task/checkToken?token=${token}`,
    method: 'get',
    headers: {
      token: token
    }
  })
}

// 获取邀请人的头像和名字信息
export const getInviteInfo = async (id) => {
  alert('获取邀请人的头像和名字信息==doctorId=》'+id)
  return request({
    url: `campaign/inviteOne/info?id=${id}`,
    method: 'get'
  })
}

// 领取课程 POST
export const getCourseById = ({ mobile, authCode, id, taskId, activityId }) => {
  return request({
    url: `campaign/inviteOne/invited`,
    method: 'post',
    data: {
      mobile, authCode, id, taskId, activityId
    },
  })
}

// 获取图形验证码
export const getCaptchaGet = async () => {
  return request({
    url: `account/account/captcha`,
    method: 'get'
  })
}

// 获取短信验证码
export const getAuthCode = ({ mobilePhone, flag, captchaToken, captchaAnswer }) => {
  return request({
    url: `account/account/authCode`,
    method: 'get',
    params: {
      mobilePhone, flag, captchaToken, captchaAnswer
    },
  })
}


