import Vue from 'vue';
// 设置电池栏高度

const mixins = {
  data() {
    return {
      statusBarHeight: 0,
      homeIndicatorHeight: 0,
      statusBarColor: '#fff'
    }
  },
  created() {
    const _this = this;
    if (!_this.$rocNative.isWeb) {
      _this.statusBarColor = _this.$rocNative.isAndroid?'#5C5C5C':'#fff'
       _this.$rocNative.getStatusBarHeight().then(res => {
        // resolve(data)
        let height = _this.$rocNative.isIOS ? res.statusBarHeight : res.statusBarHeight / window.devicePixelRatio;
        _this.statusBarHeight = height;
        //	刘海屏底部高度
         if(res.homeIndicatorHeight) {
           let homeIndicatorHeight = _this.$rocNative.isIOS ? res.homeIndicatorHeight : res.homeIndicatorHeight / window.devicePixelRatio;
           _this.homeIndicatorHeight = homeIndicatorHeight;
         }

      })
    }
  },
  mounted() {

  },
};
Vue.mixin(mixins);
