import request from './api';

/*获取三阶段主要数据*/
export const getThirdMainInfo = (params) => {
  return request({
    url: '/campaign/third/share/home/top',
    withCredentials: true,
    params: params
  })
}
/*获取榜单首页排行*/
export const getMainRank = (parmas) => {
  return request({
    url: '/campaign/third/share/home/center',
    params: parmas
  })
}
/*我的成绩*/
export const getMyGrades = (data) => {
  return request({
    url: '/campaign/third/share/result',
    method: 'post',
    data: data
  })
}
/*机构排行榜*/
export const getHospitalRank = (params) => {
  return request({
    url: '/campaign/third/share/hospital/rank',
    params: params
  })
}
/*排行榜底部个人、机构排行信息*/
export const getPersonScore = (params) => {
  return request({
    url: '/campaign/third/share/person/score',
    withCredentials: true,
    params: params
  })
}
/*个人榜单列表*/
export const getPersonList = () => {
  return request({
    url: '/campaign/third/share/person/rank',
    withCredentials: true
  })
}
/*判断活动是否结束*/
export const isGameOver = () => {
  return request({
    url: '/campaign/third/share/gameOver'
  })
}