import { app, BrowserWindow } from 'electron'
import path from 'path'
const appFolder = path.dirname(process.execPath)
const updateExe = path.resolve(appFolder, 'PICA.exe')
const exeName = path.basename(process.execPath)
// const regedit = require('regedit')
// console.log('global,', global)
// global.$eleSession = session
const isDevelopment = process.env.NODE_ENV !== 'production'
// localStorage.setItem('filePath', updateExe)
/**
 * Set `__static` path to static files in production
 * https://simulatedgreg.gitbooks.io/electron-vue/content/en/using-static-assets.html
 */
// const ex = process.execPath
if (process.env.NODE_ENV !== 'development') {
  global.__static = require('path').join(__dirname, '/static').replace(/\\/g, '\\\\')
}
// regedit.list('HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run', (err, data) => {
//   console.log('errdata', err, data, data['HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run'].values['electron.app.PICA'])
//   if (err) {
//     console.log(err)
//   }

//   if (!data['HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run'].values['electron.app.PICA'] ||
//     data['HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run'].values['electron.app.PICA'] !==
//     app.getPath('exe')) { // 未注册或注册地址与现地址不一致则 进行注册
//     regedit.putValue({
//       'HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run': {
//         'electron.app.PICA': {
//           value: app.getPath('exe'),
//           type: 'REG_SZ'
//         }
//       }
//     }, (error) => {
//       if (error) console.log(error)
//     })
//   }
// })

let mainWindow
const winURL = process.env.NODE_ENV === 'development'
  ? `http://localhost:9080`
  : `file://${__dirname}/index.html`

function createWindow() {
  /**
   * Initial window options
   */
  mainWindow = new BrowserWindow({
    height: 563,
    useContentSize: true,
    width: 1000
    // webPreferences: {
    //   nodeIntegration: true // web开启主进程中集成node
    // }
  })

  mainWindow.loadURL(winURL)

  mainWindow.on('closed', () => {
    mainWindow = null
  })
}

app.on('ready', async() => {
  createWindow()
  if (!isDevelopment) launchAtStartup()
})

app.on('window-all-closed', () => {
  if (process.platform !== 'darwin') {
    app.quit()
  }
})

app.on('activate', () => {
  if (mainWindow === null) {
    createWindow()
  }
})
function launchAtStartup() {
  if (process.platform === 'darwin') {
    app.setLoginItemSettings({
      openAtLogin: true,
      openAsHidden: true
    })
  } else {
    app.setLoginItemSettings({
      openAtLogin: true,
      openAsHidden: true,
      path: updateExe,
      args: [
        '--processStart',
        `"${exeName}"`,
        '--process-start-args',
        `"--hidden"`
      ]
    })
  }
}
/**
 * Auto Updater
 *
 * Uncomment the following code below and install `electron-updater` to
 * support auto updating. Code Signing with a valid certificate is required.
 * https://simulatedgreg.gitbooks.io/electron-vue/content/en/using-electron-builder.html#auto-updating
 */

/*
import { autoUpdater } from 'electron-updater'

autoUpdater.on('update-downloaded', () => {
  autoUpdater.quitAndInstall()
})

app.on('ready', () => {
  if (process.env.NODE_ENV === 'production') autoUpdater.checkForUpdates()
})
 */
