import router from './router'
import store from './store'
import NProgress from 'nprogress' // Progress 进度条
import 'nprogress/nprogress.css'// Progress 进度条样式
import { setAutoLogin, getAutoLogin } from './utils/auth'

const whiteList = ['/login'] // 不重定向白名单
// import { ipcMain } from 'electron'
router.beforeEach((to, from, next) => {
  NProgress.start()
  // 设置开机自启动 并记录状态在本地,
  const isAutoLogin = getAutoLogin()
  if (!(isAutoLogin && isAutoLogin === 'open')) {
    setAutoLogin('open')
    store.commit('SET_OPEN_ATLOGIN', 'open')
    console.log('isAutoLogin', getAutoLogin())
  }
  if (store.getters.token) {
    if (to.path === '/login') {
      next({ path: '/' })
      NProgress.done() // if current page is dashboard will not trigger	afterEach hook, so manually handle it
    } else {
      // if (store.getters.roles.length === 0) {
      //   store.dispatch('GetInfo').then(res => { // 拉取用户信息
      //     next()
      //   }).catch((err) => {
      //     store.dispatch('FedLogOut').then(() => {
      //       Message.error(err || 'Verification failed, please login again')
      //       next({ path: '/' })
      //     })
      //   })
      // } else {
      //   next()
      // }
      next()
    }
  } else {
    if (whiteList.indexOf(to.path) !== -1) {
      next()
    } else {
      next('/login')
      NProgress.done()
    }
  }
})

router.afterEach(() => {
  NProgress.done() // 结束Progress
})
