import {isNotEmptyUtils} from "./utils";
import Vue from 'vue';

/**
 * 配置编译环境和线上环境之间的切换
 */
const getTestEnv = (ipAddress) => {
    let environments = ["uat", "test3", "test2", "test1"];
    for (let i = 0; i < environments.length; i++) {
        if (ipAddress.indexOf(environments[i]) > -1) {
            return environments[i];
        }
    }
    return null;
};

//获取服务器路径
export const getAddress = () => {
    let ipAddress = "http://" + window.location.host;
    // let ipAddress = "http://localhost:8099";
    let env = getTestEnv(ipAddress);
    let resource_url = "";
    let locationHost = "";//模板文件路径
    let stsUrl = "";//sts服务器//获取OSS客户端
    let bucketName = "";
    let endpoint = "";
    let Url = "";//访问后台的域名
    let ossLogin = "";//内部系统登录页面
    let template_url = "" //题库模板服务器

    //本地
    if (ipAddress.indexOf("localhost") > -1 || ipAddress.indexOf("127.0.0.1") > -1 || ipAddress.indexOf("test-kf") > -1) {
        ipAddress = "http://localhost:7070";
        resource_url = "https://test-file.yunqueyi.com";
        locationHost = "http://test-kf.yunqueyi.com";
        stsUrl = "http://uat-api.yunqueyi.com/middle/oss/token";//sts服务器
        bucketName = "pica-test-huabei2";
        endpoint = "oss-cn-beijing.aliyuncs.com";
        Url = ipAddress + "/PICA_PL_BE/rest/";
        ossLogin = "http://localhost:8090/PICA_SSO_FE/html/pica_login.html";
        template_url = ipAddress
    } else if (isNotEmptyUtils(env)) {//测试test1 test2 uat
        resource_url = "https://test-file.yunqueyi.com";
        locationHost = "http://" + env + "-admin-md.yunqueyi.com";
        stsUrl = "http://" + env + "-api.yunqueyi.com/middle/oss/token";//sts服务器
        bucketName = "pica-test-huabei2";
        endpoint = "oss-cn-beijing.aliyuncs.com";
        Url = ipAddress + "/api/";
        ossLogin = "http://" + env + ".yunqueyi.com";
        template_url = "https://" + env + "-project.yunqueyi.com";
    } else {//生产环境
        resource_url = "https://file.yunqueyi.com";
        locationHost = ipAddress;
        stsUrl = "http://api.yunqueyi.com/middle/oss/token";//sts服务器
        bucketName = "pica-pro";
        endpoint = "oss-cn-shanghai.aliyuncs.com";
        Url = ipAddress + "/PICA_PL_BE/rest/";
        ossLogin = "http://sso.yunqueyi.com";
        template_url = "http://project.yunqueyi.com";
    }
    localStorage.setItem("resource_url", resource_url);
    localStorage.setItem("locationHost", locationHost);
    localStorage.setItem("Url", Url);
    localStorage.setItem("stsUrl", stsUrl);//sts服务器
    localStorage.setItem("bucketName", bucketName);//oss
    localStorage.setItem("endpoint", endpoint);//oss
    localStorage.setItem("ossLogin", ossLogin);//内部系统登录页面
    localStorage.setItem("template_url", template_url);
};


export const loadCommonFilter = () => {
    /**
     * 常量过滤器
     * @name constantFilter
     * @description:用于将[no:枚举值]转换成[value:枚举名称]
     * @param {Number} [input] 要过滤的对象
     * @param {Array} [enumList] 常量列表
     */
    Vue.filter('constantFilter', function (input, enumList) {
        let hash = {};
        if (enumList != null && enumList.length >0) {
            for (let i = 0; i < enumList.length; i++) {
                hash[enumList[i].no] = enumList[i].value;
            }
        }
        if (!input) {
            return '';
        } else {
            return hash[input];
        }
    });
};
