import Vue from 'vue';
import App from './App';
import router from './router';
import axios from 'axios';
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-default/index.css';    // 默认主题
// import '../static/css/theme-green/index.css';       // 浅绿色主题
import "babel-polyfill";
import {getAddress,loadCommonFilter} from './common/env'
import vueXlsxTable from 'vue-xlsx-table'

//加载环境变量
getAddress();
loadCommonFilter();
//加载elementUi
Vue.use(ElementUI);
Vue.use(vueXlsxTable, {rABS: false})
Vue.prototype.$axios = axios;

new Vue({
    router,
    render: h => h(App)
}).$mount('#app');
