import $http from 'mn-template/plugins/http';
import { vueApp } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';

// 设置axios默认属性
$http.setDefaults({
  headers: {}
});
// 设置http配置信息 loading、error、clear、encrypt、mockUserInfo
$http.setOptions({
  loading(opt) {
    const noLoading = opt.headers.noLoading || false;
    console.log('我重写了默认的loading1', opt);
    const globalLoading = document.getElementById('globalLoading');
    if (!globalLoading && !noLoading) {
      vueApp.$loading.show();
    }
  }
});

// 新增前置钩子
$http.addBeforeHook(config => console.log('我是新增的前置钩子', config), 0);

// 新增后置钩子
$http.addAfterHook(response => {
  vueApp.$loading.hide();
  if (response.data.code !== '000000') {
    this.$toast(response.data.message);
  }
  console.log('我是新增的后置钩子', response);
}, 0);
