import store from 'storejs';

export default {
  namespaced: true,
  state: {
    insuranceInfo: {},
    orderInfo:{}
  },
  mutations: {
    // 存值
    SET_INSURANCE_INFO(state, val = {}) {
      state.insuranceInfo = val;
    },
    SET_ORDER_INFO(state, val = {}) {
      state.orderInfo = val;
    }
  },
  actions: {
    // 暂存保险订单信息
    setInsuranceInfo({commit}, data) {
      commit('SET_INSURANCE_INFO', data);
      store.set('insuranceInfo', data);
    },
    setOrderInfo({commit}, data) {
      commit('SET_ORDER_INFO', data);
      console.log('SET_ORDER_INFO', data);
      store.set('orderInfo', data);
    },
  },
  getters: {
    // 获取 insuranceInfo 的值
    insuranceInfo: state => {
      const insuranceInfo = state.insuranceInfo.id ? state.insuranceInfo : store.get('insuranceInfo');
      return insuranceInfo || {};
    },
    // 获取 订单详情 的值
    orderInfo: state => {
      const orderInfo = state.orderInfo.yunOrderNo ? state.orderInfo : store.get('orderInfo');
      return orderInfo || {};
    }
  }
};
