import request from 'mn-template/plugins/http';
// 检测详情节点查询
export const getDetectionDetailProces = (data) => {
  return request({
    method: 'get',
    url: `/trade/detection/record/process/${data.id}?channel=${data.channel}`,
    withCredentials: true,
  });
};

// 快检 检测详情节点查询
export const getQuickDetectionDetailProces = (data) => {
  return request({
    method: 'get',
    url: `/trade/detection/record/process/${data.id}?channel=${data.channel}&detectionKind=1`,
    withCredentials: true,
  });
};

// 发送报告到钉钉工作站
export const sendReportWorkStation = (data) => {
  return request({
    method: 'get',
    url: `/store/admin/hospital/detection/reportShare/${data.id}?reportType=${data.reportType}`,
    withCredentials: true,
  });
};

// 获取报告
export const sendReportShareInfo = (data) => {
  return request({
    method: 'get',
    url: `/store/admin/hospital/detection/reportShareInfo/${data.id}?reportType=${data.reportType}`,
    withCredentials: true,
  });
};
//  获取阳性报告类型列表
export const getTypeCodeList = () => {
  return request({
    url: 'basic-data/constants/app?typeCodeList=P326',
    method: 'get',
    withCredentials: true,
  });
};

export const getTypeCodeListDemo = () => {
  return request({
    url: 'basic-data/constants/app?typeCodeList=P332',
    method: 'get',
    withCredentials: true,
  });
};
//  跟进报告提交
// /trade/detection/record/operation/submit

export const operationSubmit = (data) => {
  return request({
    method: 'post',
    url: '/trade/detection/record/operation/submit',
    data: data,
    withCredentials: true,
  });
};

// 签署协议
export const signDetection = (data) => {
  return request({
    method: 'post',
    url: '/smartcontract/protocol/sign/detection',
    data: data
  });
};

// 获取协议名称
export const getProtocolContent = (data) => {
  return request({
    url: `/smartcontract/protocol/content?type=${data.id}`,
    method: 'get',
  });
};

// 获取协议内容
export const getProtocolName = (data) => {
  return request({
    url: `/smartcontract/protocol/name?type=${data.id}`,
    method: 'GET',
  });
};

// 绑定条码
export const sampleCodeValidate = (data) => {
  return request({
    method: 'post',
    url: '/trade/detection/sampleCode/validate',
    data: data,
    withCredentials: true,
  });
};

// 获取检测人信息
export const detectionRecordInfo = (data) => {
  return request({
    method: 'get',
    url: `/trade/detection/record/record/infoV2?detectionRecordId=${data.detectionRecordId}&detectionKind=${data.detectionKind}`,
    withCredentials: true,
  });
};

// 获取检测人信息
export const detectionQuickRecordInfo = (id) => {
  return request({
    method: 'get',
    url: `/trade/detection/record/quick/info?detectionRecordId=${id}`,
    withCredentials: true,
  });
};

// 绑定条码
export const bindingSampleCode = (data) => {
  return request({
    url: '/trade/detection/applet/record/record/bindingSampleCodeV2',
    method: 'POST',
    data: data,
  });
};

export const bindingQuickSampleCode = (data) => {
  return request({
    url: '/trade/detection/applet/record/record/bindingSampleCodeV2',
    method: 'POST',
    data: data,
  });
};

export const getJumpToWebapp = (params) => {
  return request({
    url: '/applet/url/link/getUrlLink',
    method: 'post',
    data: params,
  });
};
