
import request from 'mn-template/plugins/http';
// 判断是否需要触发拼图风控
export const checkNeedImgCode = (data) => {
  return request({
    url: '/account/jigsawCode',
    method: 'post',
    data: data,
    headers: {
      sourcetype: 4,
    },
  });
};

// 获取短信验证码
export const getMessageCode = (data) => {
  return request({
    url: '/account/H5/authCode',
    method: 'post',
    data: data,
    headers: {
      sourcetype: 4,
    },
  });
};

// 获取RSA public key
export const getPubKey = (param) => {
  return request({
    url: '/account/cipher/key',
    method: 'get',
    params: param,
    headers: {
      sourcetype: 4,
    },
  });
};

// /tis/insurance / login
export const insuranceLogin = (data) => {
  return request({
    method: 'post',
    url: '/tis/insurance/login',
    data: data,
    withCredentials: true,
  });
};
// / 获取type=的协议名称
export const getProtocolContentByType = (type) => {
  return request({
    method: 'get',
    url: `/smartcontract/protocol/content?type=${type}`,
    withCredentials: true,
  });
};
 // 获取type=的协议内容
export const getProtocolNameByType = (type) => {
  return request({
    method: 'get',
    url: `/smartcontract/protocol/name?type=${type}`,
    withCredentials: true,
  });
};

//
export const getPrototypes = (projectEquityNo) => {
  return request({
    method: 'get',
    url: `tis/insurance/prototypes?projectEquityNo=${projectEquityNo}`,
    withCredentials: true,
  });
};
