import { router, } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import insuranceBindCode from '@/views/insurance-bind-code/insurance-bind-code';
import insuranceDetectionDetail from '@/views/insurance-detection-detail/insurance-detection-detail';
import insuranceBindCodeSuccess from '@/views/insurance-bindCode-success/insurance-bindCode-success';
import handleAllRouter from '../public_uat';
import { headerConfigByMeta } from 'mn-template/util/routerUtil';
const routerConfig = [
  {
    path: '/insuranceBindCode',
    name: 'insuranceBindCode',
    component: insuranceBindCode,
    meta: {
      title: '绑定条码',
    },
  },
  {
    path: '/insuranceBindCodeSuccess',
    name: 'insuranceBindCodeSuccess',
    component: insuranceBindCodeSuccess,
    meta: {
      title: '绑定成功页面',
    },
  },
  {
    path: '/insuranceDetectionDetail',
    name: 'insuranceDetectionDetail',
    component: insuranceDetectionDetail,
    meta: {
      title: '检测详情',
    },
  },
  {
    path: '/insuranceQuickDetectionDetail',
    name: 'insuranceQuickDetectionDetail',
    component: () => import('@/views/insurance-quickDetection-detail/index'),
    meta: {
      title: '快检详情',
    },
  },
  {
    path: '/insuranceDetectionDetailDemo',
    name: 'insuranceQuickDetectionDetailDemo',
    component: () => import('@/views/insurance-Detection-detail-demo/index'),
    meta: {
      title: '检测详情',
    },
  },
  {
    path: '/insuranceQuestionResult',
    name: 'insuranceQuestionResult',
    component: () => import('@/views/insurance-question-result/insuranceQuestionResult.vue'),
    meta: {
      title: '问卷结果页面',
    },
  },
  {
    path: '/insuranceQuestionResultPay',
    name: 'insuranceQuestionResultPay',
    component: () => import('@/views/insurance-question-result-pay/insuranceQuestionResult.vue'),
    meta: {
      title: '问卷结果页面',
    },
  },
  {
    path: '/insuranceQuestionBack',
    name: 'insuranceQuestionBack',
    component: () => import('@/views/insurance-question-back/index'),
  },
  {
    path: '/appoint',
    name: 'appoint',
    component: () => import('@/views/appoint/index.vue'),
    meta: {
      title: '预约',
    },
  },
  {
    path: '/appoint-demo',
    name: 'appointDemo',
    component: () => import('@/views/appoint-demo/index.vue'),
    meta: {
      title: '癌症早筛检测预约',
    },
  },
  {
    path: '/home',
    name: 'home',
    component: () => import('@/views/home/index.vue'),
    meta: {
      title: '中转页',
    },
  },
  {
    path: '/appoint-details',
    name: 'appointDetails',
    component: () => import('@/views/appointDetails/index.vue'),
    meta: {
      title: '预约详情',
    },
  },
  {
    path: '/pdf-preview',
    name: 'pdfPreview',
    component: () => import('@/views/pdf-preview/index.vue'),
    meta: {
      title: 'pdf预览',
    },
  }, //
  {
    path: '/insurance-register',
    name: 'insuranceregister',
    component: () => import('@/views/insurance-register/index.vue'),
  },
  {
    path: '/insurance-register-success',
    name: 'insuranceregistersuccess',
    component: () => import('@/views/insurance-register/register-success.vue'),
  },
  {
    path: '/sz-home',
    name: 'sz-home',
    component: () => import('@/views/sz-home/index.vue'),
  },
  {
    path: '/sz-public',
    name: 'sz-public',
    component: () => import('@/views/sz-public/index.vue'),
  },
  {
    path: '/entitlement',
    name: 'entitlement',
    component: () => import('@/views/entitlement/list.vue'),
  },
  {
    path: '/login',
    name: 'login',
    component: () => import('@/views/login/index.vue'),
    meta: {
      keepAlive: true,
    },
  },
  {
    path: '/protocol',
    name: 'protocol',
    component: () => import('@/views/login/protocol.vue'),
  },
];
router.beforeEach(async (to, from, next) => {
  headerConfigByMeta(to);
  next();

});

router.addRoutes(routerConfig);

if (process.env.VUE_APP_ENV == 'uat') {
  const routerInfo = {
    routerConfig: routerConfig,
  };
  handleAllRouter(routerInfo);
}
