module.exports = {
  transpileDependencies: [
    /[/\\]node_modules[/\\][@\\]pica-cli[/\\]vue-cli-plugin-pica-cli-plugin[/\\]core/,
    /[/\\]node_modules[/\\][@\\]pica-kit[/\\]page-model/
  ],
  productionSourceMap: false,
  pluginOptions: {
    pica: {
      jsSort: [],
      cssSort: [],
      skeletonRoutes: [],
      enableAutoSkeletonRoutes: false,
      routeMode: 'history',
      dpsLimit: 5
    },
    tinypng: {
      key: 'kYWBH2Ck5kn4BwJj8QqjcF0mZJBtZwNR'
    }
  },
  chainWebpack: config => {
          config.set('externals', {
            vue: 'Vue',
            vuex: 'Vuex',
            'vue-router': 'VueRouter',
            'vconsole': 'VConsole',
            jqery: 'jQuery',
            axios: 'axios',
            vant: 'vant',
            'crypto-js/crypto-js': 'CryptoJS',
            'jsencrypt/bin/jsencrypt': 'JSEncrypt'
          });
          config.plugins.delete('prefetch');
          config.plugins.delete('preload');
  },
  devServer: {
    port: 8083,
    proxy: {
      '/proxy': {
        target: 'https://dev-sc.yunqueyi.com/',
        // target: 'https://test1-sc.yunqueyi.com/',
        // target: 'https://uat-sc.yunqueyi.com/',
        // http://10.241.65.90:3000/mock/1071/cs/route/removeUser
        // target: 'http://10.241.65.90:3000/mock/1067',
        ws: false,
        changeOrigin: true,
        secure: true,
        pathRewrite: {
          '^/proxy': '/',
        },
      },
    },
  },
};

module.exports.publicPath = process.env.VUE_APP_ENV === 'development' && process.env.VUE_APP_IS_LOCAL ? process.env.BASE_URL : `${process.env.VUE_APP_OSS_URL}/static${process.env.BASE_URL}`;
