import store from 'storejs';

export default {
  namespaced: true,
  state: {
    insuranceInfo: {}
  },
  mutations: {
    // 存值
    SET_INSURANCE_INFO(state, val = {}) {
      state.insuranceInfo += val;
    }
  },
  actions: {
    // 暂存保险订单信息
    setInsuranceInfo({commit}, data) {
      commit('SET_INSURANCE_INFO', data);
      store.set('insuranceInfo', data);
    },
  },
  getters: {
    // 获取 insuranceInfo 的值
    insuranceInfo: state => {
      const insuranceInfo = state.insuranceInfo.id ? state.insuranceInfo : store.get('insuranceInfo');
      return insuranceInfo || {};
    }
  }
};
