import request from 'mn-template/plugins/http';
//  获取检测详情 接口
export const getButtonStatus = (id) => {
  return request({
    method: 'get',
    url: `/tis/insurance/makeAppointmentStatus?yunOrderNo=${id}`,
    withCredentials: true,
  });
};
// 根据订单号获取跳转页状态/
// /tis/insurance/jumpPageStatus?orderNo=1&projectEquityNo=1
export const getJumpPageStatus = ({externalOrderNo, yunOrderNo, projectEquityNo}) => {
  return request({
    method: 'get',
    url: `/tis/insurance/jumpPageStatus?externalOrderNo=${externalOrderNo}&projectEquityNo=${projectEquityNo}&yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
  });
};

export const createOrder = (data) => {
  return request({
    method: 'post',
    data,
    url: '/tis/insurance/create/order',
    withCredentials: true,
  });
};

export const getLanZhouFlag = (externalOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/common/lanZhou/flag/${externalOrderNo}`,
    withCredentials: true,
  });
};
export const createOrderSz = (data) => {
  return request({
    url: '/tis/insurance/middleware/create/order/sz',
    method: 'POST',
    withCredentials: true,
    data,
  });
};

export const createOrderSzV2 = (data) => {
  return request({
    url: '/tis/insurance/middleware/create/order/sz/v2',
    method: 'POST',
    withCredentials: true,
    data,
  });
};
