import { router } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import insuranceBindCode from '@/views/insurance-bind-code/insurance-bind-code';
import insuranceDetectionDetail from '@/views/insurance-detection-detail/insurance-detection-detail';
import insuranceBindCodeSuccess from '@/views/insurance-bindCode-success/insurance-bindCode-success';
import handleAllRouter from '../public_uat';
const routerConfig = [
  {
    path: '/insuranceBindCode',
    name: 'insuranceBindCode',
    component: insuranceBindCode
  },
  {
    path: '/insuranceBindCodeSuccess',
    name: 'insuranceBindCodeSuccess',
    component: insuranceBindCodeSuccess
  },
  {
    path: '/insuranceDetectionDetail',
    name: 'insuranceDetectionDetail',
    component: insuranceDetectionDetail
  },
  {
    path: '/insuranceQuestionResult',
    name: 'insuranceQuestionResult',
    component: () => import('@/views/insurance-question-result/insuranceQuestionResult.vue'),
  },
  {
    path: '/insuranceQuestionBack',
    name: 'insuranceQuestionBack',
    component: () => import('@/views/insurance-question-back/index'),
  },
  {
    path: '/appoint',
    name: 'appoint',
    component: () => import('@/views/appoint/index.vue'),
  },
  {
    path: '/geoNavigation',
    name: 'geoNavigation',
    component: () => import('@/views/geoNavigation/index.vue'),
  },
  {
    path: '/home',
    name: 'home',
    component: () => import('@/views/home/index.vue'),
  },
  {
    path: '/appoint-details',
    name: 'appointDetails',
    component: () => import('@/views/appointDetails/index.vue'),
  },
  {
    path: '/pdf-preview',
    name: 'pdfPreview',
    component: () => import('@/views/pdf-preview/index.vue'),
  }, //
  {
    path: '/insurance-register',
    name: 'insuranceregister',
    component: () => import('@/views/insurance-register/index.vue'),
  },
  {
    path: '/insurance-register-success',
    name: 'insuranceregistersuccess',
    component: () => import('@/views/insurance-register/register-success.vue'),
  },
];
// // 无问卷-0001 有问卷未填写-0101 已填写问卷未出结果-0102 已出结果无需领用-0401 已出结果未预约-0201 已预约未采样-0301 已预约已采样-0302
// const routerMap = {
//   '0001': null,
//   '0101': null,
//   '0102': null,
//   '0401': null,
//   '0201': '/appoint',
//   '0301': null,
//   '0302': null,
// };
router.beforeEach(async (to, from, next) => {
  console.log(to, from, next);
  next();

});

router.addRoutes(routerConfig);

if (process.env.VUE_APP_ENV == 'uat') {
  const routerInfo = {
    routerConfig: routerConfig,
  };
  handleAllRouter(routerInfo);
}
