
import request from 'mn-template/plugins/http';

// 根据订单号获取检测名称
// /tis/insurance/detectionName?yunOrderNo=11
export const getDetectionName = (yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/detectionName?yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
  });
};

// /tis/insurance/order/info?yunOrderNo=1
// 查询订单信息
export const getOrderInfo = (yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/order/info?yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
  });
};
export const appointment = (data) => {
  return request({
    method: 'post',
    data,
    url: '/tis/insurance/appointment',
    withCredentials: true,
  });
};

// /insurance/getDetailByYunOrderNo
// 查看预约详情
export const getDetailByYunOrderNo = (yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/getDetailByYunOrderNo?yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
  });
};
export const getHospitalList = (params) => {
  return request({
    method: 'GET',
    params,
    url: '/tis/insurance/hospitalList',
    withCredentials: true,
  });
};
