import { router } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import Index from '@/views/index.vue';
import { toggleSkeletonRouter } from 'mn-template/plugins/toggleSkeleton.js';
import handleAllRouter from '../public_uat';

const routerConfig = [
  {
    path: '/',
    name: 'Index',
    component: Index,
  },
  {
    path: '/entrance',
    name: 'entrance',
    component: Index,
  },
  {
    path: '/result',
    name: 'result',
    component: () => import('@/views/result/index.vue'),
  },
  {
    path: '/result-risk',
    name: 'resultRisk',
    component: () => import('@/views/result/risk.vue'),
  },
  {
    path: '/appoint',
    name: 'appoint',
    component: () => import('@/views/appoint/index.vue'),
  },
  {
    path: '*',
    redirect: process.env.VUE_APP_BASE_ROUTE,
  },
];

router.beforeEach(async (to, from, next) => {
  toggleSkeletonRouter(to, from);
  next();
});

router.addRoutes(routerConfig);

if (process.env.VUE_APP_ENV == 'uat') {
  const routerInfo = {
    routerConfig: routerConfig,
  };
  handleAllRouter(routerInfo);
}
