import request from 'mn-template/plugins/http';

// 根据订单号获取检测名称
export const getDetectionName = async (yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/detectionName?yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
  });
};

// /tis/insurance/order/info?yunOrderNo=1
// 查询订单信息
export const getOrderInfo = async (yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/order/info?yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
  });
};
export const appointment = async (data) => {
  return request({
    method: 'post',
    data,
    url: '/tis/insurance/appointment',
    withCredentials: true,
  });
};

// /insurance/getDetailByYunOrderNo
// 查看预约详情
export const getDetailByYunOrderNo = async (yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/getDetailByYunOrderNo?yunOrderNo=${yunOrderNo}`,
    withCredentials: true,
    hasLoading: false,
  });
};
export const getHospitalList = async (data) => {
  return request({
    method: 'post',
    data,
    headers: {
      noLoading: true,
    },
    url: '/tis/insurance/hospitalList',
    withCredentials: true,
  });
};

export const getDetailHospital = async (id) => {
  return request({
    method: 'get',
    url: `hospital/hospitals/hospital/${id}/encrypt`,
    withCredentials: true,
  });
};

export const getCheckInUserInfo = async (data) => {
  return request({
    method: 'post',
    data,
    url: '/tis/marketing/checkInUserInfo',
    withCredentials: true,
  });
};

// /tis/insurance / save / order / detection / result
export const saveOrder = async (data) => {
  return request({
    method: 'post',
    data,
    url: '/tis/insurance/save/order/detection/result',
    withCredentials: true,
  });
};

export const getDetailtxt = async (data) => {
  return request({
    method: 'get',
    url: `tis/insurance/explain/${data.yunOrderNo}/${data.pageType}`,
    withCredentials: true,
  });
};
// 博斯腾判断订单是否完成
export const bestcoveredStatusCheck = async (data) => {
  return request({
    method: 'get',
    url: `/trade/detection/bestcovered/checkComplete/${data.orderNo}/${data.source}`,
    withCredentials: true,
  });
};
